/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import java.util.Set;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.And;
import org.apache.iceberg.expressions.Bound;
import org.apache.iceberg.expressions.BoundLiteralPredicate;
import org.apache.iceberg.expressions.BoundPredicate;
import org.apache.iceberg.expressions.BoundReference;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.expressions.Not;
import org.apache.iceberg.expressions.Or;
import org.apache.iceberg.expressions.Predicate;
import org.apache.iceberg.expressions.UnboundPredicate;

public class ExpressionVisitors {
    private ExpressionVisitors() {
    }

    public static <R> R visit(Expression expr, ExpressionVisitor<R> visitor) {
        if (expr instanceof Predicate) {
            if (expr instanceof BoundPredicate) {
                return visitor.predicate((BoundPredicate)expr);
            }
            return visitor.predicate((UnboundPredicate)expr);
        }
        switch (expr.op()) {
            case TRUE: {
                return visitor.alwaysTrue();
            }
            case FALSE: {
                return visitor.alwaysFalse();
            }
            case NOT: {
                Not not = (Not)expr;
                return visitor.not(ExpressionVisitors.visit(not.child(), visitor));
            }
            case AND: {
                And and = (And)expr;
                return visitor.and(ExpressionVisitors.visit(and.left(), visitor), ExpressionVisitors.visit(and.right(), visitor));
            }
            case OR: {
                Or or = (Or)expr;
                return visitor.or(ExpressionVisitors.visit(or.left(), visitor), ExpressionVisitors.visit(or.right(), visitor));
            }
        }
        throw new UnsupportedOperationException("Unknown operation: " + (Object)((Object)expr.op()));
    }

    public static Boolean visitEvaluator(Expression expr, ExpressionVisitor<Boolean> visitor) {
        if (expr instanceof Predicate) {
            if (expr instanceof BoundPredicate) {
                return visitor.predicate((BoundPredicate)expr);
            }
            return visitor.predicate((UnboundPredicate)expr);
        }
        switch (expr.op()) {
            case TRUE: {
                return visitor.alwaysTrue();
            }
            case FALSE: {
                return visitor.alwaysFalse();
            }
            case NOT: {
                Not not = (Not)expr;
                return visitor.not(ExpressionVisitors.visitEvaluator(not.child(), visitor));
            }
            case AND: {
                And and = (And)expr;
                Boolean andLeftOperand = ExpressionVisitors.visitEvaluator(and.left(), visitor);
                if (!andLeftOperand.booleanValue()) {
                    return visitor.alwaysFalse();
                }
                return visitor.and(Boolean.TRUE, ExpressionVisitors.visitEvaluator(and.right(), visitor));
            }
            case OR: {
                Or or = (Or)expr;
                Boolean orLeftOperand = ExpressionVisitors.visitEvaluator(or.left(), visitor);
                if (orLeftOperand.booleanValue()) {
                    return visitor.alwaysTrue();
                }
                return visitor.or(Boolean.FALSE, ExpressionVisitors.visitEvaluator(or.right(), visitor));
            }
        }
        throw new UnsupportedOperationException("Unknown operation: " + (Object)((Object)expr.op()));
    }

    public static abstract class BoundVisitor<R>
    extends ExpressionVisitor<R> {
        public <T> R isNull(Bound<T> expr) {
            return null;
        }

        public <T> R notNull(Bound<T> expr) {
            return null;
        }

        public <T> R lt(Bound<T> expr, Literal<T> lit) {
            return null;
        }

        public <T> R ltEq(Bound<T> expr, Literal<T> lit) {
            return null;
        }

        public <T> R gt(Bound<T> expr, Literal<T> lit) {
            return null;
        }

        public <T> R gtEq(Bound<T> expr, Literal<T> lit) {
            return null;
        }

        public <T> R eq(Bound<T> expr, Literal<T> lit) {
            return null;
        }

        public <T> R notEq(Bound<T> expr, Literal<T> lit) {
            return null;
        }

        public <T> R in(Bound<T> expr, Set<T> literalSet) {
            throw new UnsupportedOperationException("In operation is not supported by the visitor");
        }

        public <T> R notIn(Bound<T> expr, Set<T> literalSet) {
            throw new UnsupportedOperationException("notIn operation is not supported by the visitor");
        }

        public <T> R startsWith(Bound<T> expr, Literal<T> lit) {
            throw new UnsupportedOperationException("Unsupported operation.");
        }

        @Override
        public <T> R predicate(BoundPredicate<T> pred) {
            if (pred.isLiteralPredicate()) {
                BoundLiteralPredicate<T> literalPred = pred.asLiteralPredicate();
                switch (pred.op()) {
                    case LT: {
                        return this.lt((Bound)pred.term(), literalPred.literal());
                    }
                    case LT_EQ: {
                        return this.ltEq((Bound)pred.term(), literalPred.literal());
                    }
                    case GT: {
                        return this.gt((Bound)pred.term(), literalPred.literal());
                    }
                    case GT_EQ: {
                        return this.gtEq((Bound)pred.term(), literalPred.literal());
                    }
                    case EQ: {
                        return this.eq((Bound)pred.term(), literalPred.literal());
                    }
                    case NOT_EQ: {
                        return this.notEq((Bound)pred.term(), literalPred.literal());
                    }
                    case STARTS_WITH: {
                        return this.startsWith((Bound)pred.term(), literalPred.literal());
                    }
                }
                throw new IllegalStateException("Invalid operation for BoundLiteralPredicate: " + (Object)((Object)pred.op()));
            }
            if (pred.isUnaryPredicate()) {
                switch (pred.op()) {
                    case IS_NULL: {
                        return this.isNull((Bound)pred.term());
                    }
                    case NOT_NULL: {
                        return this.notNull((Bound)pred.term());
                    }
                }
                throw new IllegalStateException("Invalid operation for BoundUnaryPredicate: " + (Object)((Object)pred.op()));
            }
            if (pred.isSetPredicate()) {
                switch (pred.op()) {
                    case IN: {
                        return this.in((Bound)pred.term(), pred.asSetPredicate().literalSet());
                    }
                    case NOT_IN: {
                        return this.notIn((Bound)pred.term(), pred.asSetPredicate().literalSet());
                    }
                }
                throw new IllegalStateException("Invalid operation for BoundSetPredicate: " + (Object)((Object)pred.op()));
            }
            throw new IllegalStateException("Unsupported bound predicate: " + pred.getClass().getName());
        }

        @Override
        public <T> R predicate(UnboundPredicate<T> pred) {
            throw new UnsupportedOperationException("Not a bound predicate: " + pred);
        }
    }

    @Deprecated
    public static abstract class BoundExpressionVisitor<R>
    extends ExpressionVisitor<R> {
        public <T> R isNull(BoundReference<T> ref) {
            return null;
        }

        public <T> R notNull(BoundReference<T> ref) {
            return null;
        }

        public <T> R lt(BoundReference<T> ref, Literal<T> lit) {
            return null;
        }

        public <T> R ltEq(BoundReference<T> ref, Literal<T> lit) {
            return null;
        }

        public <T> R gt(BoundReference<T> ref, Literal<T> lit) {
            return null;
        }

        public <T> R gtEq(BoundReference<T> ref, Literal<T> lit) {
            return null;
        }

        public <T> R eq(BoundReference<T> ref, Literal<T> lit) {
            return null;
        }

        public <T> R notEq(BoundReference<T> ref, Literal<T> lit) {
            return null;
        }

        public <T> R in(BoundReference<T> ref, Set<T> literalSet) {
            throw new UnsupportedOperationException("In operation is not supported by the visitor");
        }

        public <T> R notIn(BoundReference<T> ref, Set<T> literalSet) {
            throw new UnsupportedOperationException("notIn operation is not supported by the visitor");
        }

        public <T> R startsWith(BoundReference<T> ref, Literal<T> lit) {
            throw new UnsupportedOperationException("Unsupported operation.");
        }

        @Override
        public <T> R predicate(BoundPredicate<T> pred) {
            ValidationException.check(pred.term() instanceof BoundReference, "Visitor %s does not support expression: %s", this, pred.term());
            if (pred.isLiteralPredicate()) {
                BoundLiteralPredicate<T> literalPred = pred.asLiteralPredicate();
                switch (pred.op()) {
                    case LT: {
                        return this.lt((BoundReference)pred.term(), literalPred.literal());
                    }
                    case LT_EQ: {
                        return this.ltEq((BoundReference)pred.term(), literalPred.literal());
                    }
                    case GT: {
                        return this.gt((BoundReference)pred.term(), literalPred.literal());
                    }
                    case GT_EQ: {
                        return this.gtEq((BoundReference)pred.term(), literalPred.literal());
                    }
                    case EQ: {
                        return this.eq((BoundReference)pred.term(), literalPred.literal());
                    }
                    case NOT_EQ: {
                        return this.notEq((BoundReference)pred.term(), literalPred.literal());
                    }
                    case STARTS_WITH: {
                        return this.startsWith((BoundReference)pred.term(), literalPred.literal());
                    }
                }
                throw new IllegalStateException("Invalid operation for BoundLiteralPredicate: " + (Object)((Object)pred.op()));
            }
            if (pred.isUnaryPredicate()) {
                switch (pred.op()) {
                    case IS_NULL: {
                        return this.isNull((BoundReference)pred.term());
                    }
                    case NOT_NULL: {
                        return this.notNull((BoundReference)pred.term());
                    }
                }
                throw new IllegalStateException("Invalid operation for BoundUnaryPredicate: " + (Object)((Object)pred.op()));
            }
            if (pred.isSetPredicate()) {
                switch (pred.op()) {
                    case IN: {
                        return this.in((BoundReference)pred.term(), pred.asSetPredicate().literalSet());
                    }
                    case NOT_IN: {
                        return this.notIn((BoundReference)pred.term(), pred.asSetPredicate().literalSet());
                    }
                }
                throw new IllegalStateException("Invalid operation for BoundSetPredicate: " + (Object)((Object)pred.op()));
            }
            throw new IllegalStateException("Unsupported bound predicate: " + pred.getClass().getName());
        }

        @Override
        public <T> R predicate(UnboundPredicate<T> pred) {
            throw new UnsupportedOperationException("Not a bound predicate: " + pred);
        }
    }

    public static abstract class ExpressionVisitor<R> {
        public R alwaysTrue() {
            return null;
        }

        public R alwaysFalse() {
            return null;
        }

        public R not(R result) {
            return null;
        }

        public R and(R leftResult, R rightResult) {
            return null;
        }

        public R or(R leftResult, R rightResult) {
            return null;
        }

        public <T> R predicate(BoundPredicate<T> pred) {
            return null;
        }

        public <T> R predicate(UnboundPredicate<T> pred) {
            return null;
        }
    }
}

