/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.client;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.protocol.HttpAsyncClientProtocolHandler;

class LoggingClientProtocolHandler
extends HttpAsyncClientProtocolHandler {
    private final Log log = LogFactory.getLog(HttpAsyncClientProtocolHandler.class);

    protected void onException(Exception ex) {
        this.log.debug((Object)ex.getMessage(), (Throwable)ex);
    }

    public void connected(NHttpClientConnection conn, Object attachment) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(conn + ": Connected"));
        }
        super.connected(conn, attachment);
    }

    public void closed(NHttpClientConnection conn) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(conn + ": Disconnected"));
        }
        super.closed(conn);
    }

    public void exception(NHttpClientConnection conn, HttpException ex) {
        if (this.log.isErrorEnabled()) {
            this.log.error((Object)(conn + " HTTP protocol exception: " + ex.getMessage()), (Throwable)ex);
        }
        super.exception(conn, ex);
    }

    public void exception(NHttpClientConnection conn, IOException ex) {
        if (this.log.isErrorEnabled()) {
            this.log.error((Object)(conn + " I/O error: " + ex.getMessage()), (Throwable)ex);
        }
        super.exception(conn, ex);
    }

    public void requestReady(NHttpClientConnection conn) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(conn + " Request ready"));
        }
        super.requestReady(conn);
    }

    public void inputReady(NHttpClientConnection conn, ContentDecoder decoder) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(conn + " Input ready " + decoder));
        }
        super.inputReady(conn, decoder);
    }

    public void outputReady(NHttpClientConnection conn, ContentEncoder encoder) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(conn + " Output ready " + encoder));
        }
        super.outputReady(conn, encoder);
    }

    public void responseReceived(NHttpClientConnection conn) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(conn + " Response received"));
        }
        super.responseReceived(conn);
    }

    public void timeout(NHttpClientConnection conn) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(conn + " Timeout"));
        }
        super.timeout(conn);
    }
}

