/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.client;

import java.io.IOException;
import org.apache.http.impl.nio.reactor.SSLIOSession;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.NHttpClientHandler;
import org.apache.http.nio.conn.OperatedClientConnection;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOSession;

class InternalClientEventDispatch
implements IOEventDispatch {
    private final NHttpClientHandler handler;

    InternalClientEventDispatch(NHttpClientHandler handler) {
        this.handler = handler;
    }

    private OperatedClientConnection getConnection(IOSession session) {
        return (OperatedClientConnection)session.getAttribute("http.connection");
    }

    private void assertValid(OperatedClientConnection conn) {
        if (conn == null) {
            throw new IllegalStateException("HTTP connection is null");
        }
    }

    public void connected(IOSession session) {
        OperatedClientConnection conn = this.getConnection(session);
        this.assertValid(conn);
        Object attachment = session.getAttribute("http.session.attachment");
        this.handler.connected((NHttpClientConnection)conn, attachment);
    }

    public void disconnected(IOSession session) {
        OperatedClientConnection conn = this.getConnection(session);
        if (conn != null) {
            this.handler.closed((NHttpClientConnection)conn);
        }
    }

    public void inputReady(IOSession session) {
        OperatedClientConnection conn = this.getConnection(session);
        this.assertValid(conn);
        SSLIOSession ssliosession = conn.getSSLIOSession();
        if (ssliosession == null) {
            conn.consumeInput(this.handler);
        } else {
            try {
                if (ssliosession.isAppInputReady()) {
                    conn.consumeInput(this.handler);
                }
                ssliosession.inboundTransport();
            }
            catch (IOException ex) {
                this.handler.exception((NHttpClientConnection)conn, ex);
                ssliosession.shutdown();
            }
        }
    }

    public void outputReady(IOSession session) {
        OperatedClientConnection conn = this.getConnection(session);
        this.assertValid(conn);
        SSLIOSession ssliosession = conn.getSSLIOSession();
        if (ssliosession == null) {
            conn.produceOutput(this.handler);
        } else {
            try {
                if (ssliosession.isAppOutputReady()) {
                    conn.produceOutput(this.handler);
                }
                ssliosession.outboundTransport();
            }
            catch (IOException ex) {
                this.handler.exception((NHttpClientConnection)conn, ex);
                ssliosession.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timeout(IOSession session) {
        OperatedClientConnection conn = this.getConnection(session);
        if (conn != null) {
            SSLIOSession ssliosession = conn.getSSLIOSession();
            if (ssliosession == null) {
                this.handler.timeout((NHttpClientConnection)conn);
            } else {
                this.handler.timeout((NHttpClientConnection)conn);
                SSLIOSession sSLIOSession = ssliosession;
                synchronized (sSLIOSession) {
                    if (ssliosession.isOutboundDone() && !ssliosession.isInboundDone()) {
                        ssliosession.shutdown();
                    }
                }
            }
        }
    }
}

