/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.client;

import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.impl.nio.client.MessageState;

class HttpExchange {
    private MessageState requestState = MessageState.READY;
    private MessageState responseState = MessageState.READY;
    private HttpRequest request;
    private HttpResponse response;
    private boolean valid = true;
    private int timeout;

    public MessageState getRequestState() {
        return this.requestState;
    }

    public void setRequestState(MessageState state) {
        this.requestState = state;
    }

    public MessageState getResponseState() {
        return this.responseState;
    }

    public void setResponseState(MessageState state) {
        this.responseState = state;
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpRequest request) {
        this.request = request;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public void setResponse(HttpResponse response) {
        this.response = response;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void resetInput() {
        this.response = null;
        this.responseState = MessageState.READY;
    }

    public void resetOutput() {
        this.request = null;
        this.requestState = MessageState.READY;
    }

    public void reset() {
        this.resetInput();
        this.resetOutput();
    }

    public boolean isValid() {
        return this.valid;
    }

    public void invalidate() {
        this.valid = false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[request state=");
        buf.append((Object)this.requestState);
        if (this.request != null) {
            buf.append(",request=");
            buf.append(this.request.getRequestLine());
        }
        buf.append(",response state=");
        buf.append((Object)this.responseState);
        if (this.response != null) {
            buf.append(",response=");
            buf.append(this.response.getStatusLine());
        }
        buf.append(",valid=");
        buf.append(this.valid);
        buf.append("]");
        return buf.toString();
    }
}

