/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.client;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.client.HttpAsyncResponseConsumer;
import org.apache.http.nio.entity.BufferingNHttpEntity;
import org.apache.http.nio.entity.ConsumingNHttpEntity;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.HeapByteBufferAllocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicHttpAsyncResponseConsumer
implements HttpAsyncResponseConsumer<HttpResponse> {
    private volatile HttpResponse response;
    private volatile ConsumingNHttpEntity contentConsumingEntity;
    private volatile HttpResponse result;
    private volatile Exception ex;
    private volatile boolean completed;

    protected ConsumingNHttpEntity createConsumingHttpEntity(HttpResponse response) throws IOException {
        if (response.getEntity() != null) {
            return new BufferingNHttpEntity(response.getEntity(), (ByteBufferAllocator)new HeapByteBufferAllocator());
        }
        return null;
    }

    private ConsumingNHttpEntity getConsumingHttpEntity() throws IOException {
        if (this.contentConsumingEntity == null) {
            this.contentConsumingEntity = this.createConsumingHttpEntity(this.response);
            if (this.contentConsumingEntity == null) {
                throw new IllegalStateException("Content consumer is null");
            }
        }
        return this.contentConsumingEntity;
    }

    private void releaseResources() {
        if (this.contentConsumingEntity != null) {
            try {
                this.contentConsumingEntity.finish();
                this.contentConsumingEntity = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized void responseReceived(HttpResponse response) {
        if (this.response != null) {
            throw new IllegalStateException("HTTP response already set");
        }
        this.response = response;
    }

    @Override
    public synchronized void consumeContent(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        ConsumingNHttpEntity consumer = this.getConsumingHttpEntity();
        consumer.consumeContent(decoder, ioctrl);
        if (decoder.isCompleted()) {
            this.response.setEntity((HttpEntity)consumer);
            this.releaseResources();
        }
    }

    @Override
    public synchronized void responseCompleted() {
        if (this.completed) {
            return;
        }
        this.completed = true;
        if (this.response != null) {
            this.result = this.response;
        }
        this.releaseResources();
    }

    @Override
    public synchronized void cancel() {
        if (this.completed) {
            return;
        }
        this.completed = true;
        this.response = null;
        this.releaseResources();
    }

    @Override
    public synchronized void failed(Exception ex) {
        if (this.completed) {
            return;
        }
        this.completed = true;
        this.ex = ex;
        this.response = null;
        this.releaseResources();
    }

    public Exception getException() {
        return this.ex;
    }

    public void setEx(Exception ex) {
        this.ex = ex;
    }

    @Override
    public HttpResponse getResult() {
        return this.result;
    }
}

