/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.pool;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.http.nio.reactor.IOSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PoolEntry<T> {
    private static AtomicLong COUNTER = new AtomicLong();
    private final long id;
    private final T route;
    private final IOSession session;
    private final long created;
    private final long validUnit;
    private Object state;
    private long updated;
    private long expiry;

    public PoolEntry(T route, IOSession session, long timeToLive, TimeUnit tunit) {
        if (route == null) {
            throw new IllegalArgumentException("Route may not be null");
        }
        if (session == null) {
            throw new IllegalArgumentException("I/O session may not be null");
        }
        if (tunit == null) {
            throw new IllegalArgumentException("Time unit may not be null");
        }
        this.route = route;
        this.session = session;
        this.id = COUNTER.incrementAndGet();
        this.created = System.currentTimeMillis();
        this.validUnit = timeToLive > 0L ? this.created + tunit.toMillis(timeToLive) : Long.MAX_VALUE;
    }

    protected T getRoute() {
        return this.route;
    }

    protected IOSession getIOSession() {
        return this.session;
    }

    public long getCreated() {
        return this.created;
    }

    public long getValidUnit() {
        return this.validUnit;
    }

    protected Object getState() {
        return this.state;
    }

    protected void setState(Object state) {
        this.state = state;
    }

    public long getUpdated() {
        return this.updated;
    }

    public long getExpiry() {
        return this.expiry;
    }

    public void updateExpiry(long time, TimeUnit tunit) {
        if (tunit == null) {
            throw new IllegalArgumentException("Time unit may not be null");
        }
        this.updated = System.currentTimeMillis();
        long newExpiry = time > 0L ? this.updated + tunit.toMillis(time) : Long.MAX_VALUE;
        this.expiry = Math.min(newExpiry, this.validUnit);
    }

    public boolean isExpired(long now) {
        return now >= this.expiry;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[id:");
        buffer.append(this.id);
        buffer.append("][route:");
        buffer.append(this.route);
        buffer.append("][state:");
        buffer.append(this.state);
        buffer.append("]");
        return buffer.toString();
    }
}

