/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.cache.HttpCacheEntry;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.client.cache.AsynchronousAsyncValidator;
import org.apache.http.impl.client.cache.CachingHttpAsyncClient;
import org.apache.http.protocol.HttpContext;

class AsynchronousAsyncValidationRequest
implements Runnable {
    private final AsynchronousAsyncValidator parent;
    private final CachingHttpAsyncClient cachingAsyncClient;
    private final HttpHost target;
    private final HttpRequestWrapper request;
    private final HttpContext context;
    private final HttpCacheEntry cacheEntry;
    private final String identifier;
    private final Log log = LogFactory.getLog(this.getClass());

    AsynchronousAsyncValidationRequest(AsynchronousAsyncValidator parent, CachingHttpAsyncClient cachingClient, HttpHost target, HttpRequestWrapper request, HttpContext context, HttpCacheEntry cacheEntry, String identifier) {
        this.parent = parent;
        this.cachingAsyncClient = cachingClient;
        this.target = target;
        this.request = request;
        this.context = context;
        this.cacheEntry = cacheEntry;
        this.identifier = identifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.cachingAsyncClient.revalidateCacheEntry(this.target, this.request, this.context, this.cacheEntry, new FutureCallback<HttpResponse>(){

                public void cancelled() {
                }

                public void completed(HttpResponse httpResponse) {
                }

                public void failed(Exception e) {
                    if (e instanceof IOException) {
                        AsynchronousAsyncValidationRequest.this.log.debug((Object)("Asynchronous revalidation failed due to exception: " + e));
                    }
                }
            });
        }
        catch (ProtocolException pe) {
            this.log.error((Object)("ProtocolException thrown during asynchronous revalidation: " + (Object)((Object)pe)));
        }
        finally {
            this.parent.markComplete(this.identifier);
        }
    }

    String getIdentifier() {
        return this.identifier;
    }
}

