/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.shaded.jetty.client;

import org.apache.htrace.shaded.jetty.client.HttpClient;
import org.apache.htrace.shaded.jetty.client.HttpRedirector;
import org.apache.htrace.shaded.jetty.client.ProtocolHandler;
import org.apache.htrace.shaded.jetty.client.api.Request;
import org.apache.htrace.shaded.jetty.client.api.Response;
import org.apache.htrace.shaded.jetty.client.api.Result;

public class RedirectProtocolHandler
extends Response.Listener.Adapter
implements ProtocolHandler {
    private final HttpRedirector redirector;

    public RedirectProtocolHandler(HttpClient client) {
        this.redirector = new HttpRedirector(client);
    }

    @Override
    public boolean accept(Request request, Response response) {
        return this.redirector.isRedirect(response) && request.isFollowRedirects();
    }

    @Override
    public Response.Listener getResponseListener() {
        return this;
    }

    @Override
    public void onComplete(Result result) {
        Request request = result.getRequest();
        Response response = result.getResponse();
        if (result.isSucceeded()) {
            this.redirector.redirect(request, response, null);
        } else {
            this.redirector.fail(request, response, result.getFailure());
        }
    }
}

