/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.shaded.jetty.client;

import java.io.IOException;
import java.util.Arrays;
import org.apache.htrace.shaded.jetty.client.ConnectionPool;
import org.apache.htrace.shaded.jetty.client.HttpClient;
import org.apache.htrace.shaded.jetty.client.HttpDestination;
import org.apache.htrace.shaded.jetty.client.HttpExchange;
import org.apache.htrace.shaded.jetty.client.Origin;
import org.apache.htrace.shaded.jetty.client.api.Connection;
import org.apache.htrace.shaded.jetty.client.api.Request;
import org.apache.htrace.shaded.jetty.util.Promise;
import org.apache.htrace.shaded.jetty.util.component.ContainerLifeCycle;

public abstract class PoolingHttpDestination<C extends Connection>
extends HttpDestination
implements Promise<Connection> {
    private final ConnectionPool connectionPool;

    public PoolingHttpDestination(HttpClient client, Origin origin) {
        super(client, origin);
        this.connectionPool = this.newConnectionPool(client);
    }

    protected ConnectionPool newConnectionPool(HttpClient client) {
        return new ConnectionPool(this, client.getMaxConnectionsPerDestination(), this);
    }

    public ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    @Override
    public void succeeded(Connection connection) {
        this.process(connection, true);
    }

    @Override
    public void failed(final Throwable x) {
        this.getHttpClient().getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                PoolingHttpDestination.this.abort(x);
            }
        });
    }

    @Override
    protected void send() {
        C connection = this.acquire();
        if (connection != null) {
            this.process(connection, false);
        }
    }

    public C acquire() {
        return (C)this.connectionPool.acquire();
    }

    public void process(C connection, boolean dispatch) {
        HttpClient client = this.getHttpClient();
        HttpExchange exchange = this.getHttpExchanges().poll();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing exchange {} on {} of {}", exchange, connection, this);
        }
        if (exchange == null) {
            if (!this.connectionPool.release((Connection)connection)) {
                connection.close();
            }
            if (!client.isRunning()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} is stopping", client);
                }
                connection.close();
            }
        } else {
            Request request = exchange.getRequest();
            Throwable cause = request.getAbortCause();
            if (cause != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Aborted before processing {}: {}", exchange, cause);
                }
                exchange.abort(cause);
            } else if (dispatch) {
                client.getExecutor().execute(new Runnable((Connection)connection, exchange){
                    final /* synthetic */ Connection val$connection;
                    final /* synthetic */ HttpExchange val$exchange;
                    {
                        this.val$connection = connection;
                        this.val$exchange = httpExchange;
                    }

                    @Override
                    public void run() {
                        PoolingHttpDestination.this.send(this.val$connection, this.val$exchange);
                    }
                });
            } else {
                this.send(connection, exchange);
            }
        }
    }

    protected abstract void send(C var1, HttpExchange var2);

    @Override
    public void release(Connection c) {
        HttpClient client;
        Connection connection = c;
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} released", connection);
        }
        if ((client = this.getHttpClient()).isRunning()) {
            if (this.connectionPool.isActive(connection)) {
                this.process(connection, false);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("{} explicit", connection);
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} is stopped", client);
            }
            this.close(connection);
            connection.close();
        }
    }

    @Override
    public void close(Connection oldConnection) {
        super.close(oldConnection);
        this.connectionPool.remove(oldConnection);
        if (this.getHttpExchanges().isEmpty()) {
            if (this.getHttpClient().isRemoveIdleDestinations() && this.connectionPool.isEmpty()) {
                this.getHttpClient().removeDestination(this);
            }
        } else {
            C newConnection = this.acquire();
            if (newConnection != null) {
                this.process(newConnection, false);
            }
        }
    }

    @Override
    public void close() {
        super.close();
        this.connectionPool.close();
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        ContainerLifeCycle.dump(out, indent, Arrays.asList(this.connectionPool));
    }

    @Override
    public String toString() {
        return String.format("%s,pool=%s", super.toString(), this.connectionPool);
    }
}

