/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.msgpack.core;

import org.apache.htrace.msgpack.core.Preconditions;

public class ExtendedTypeHeader {
    private final int length;
    private final int type;

    ExtendedTypeHeader(int n, int n2) {
        Preconditions.checkArgument(n >= 0, String.format("length must be >= 0: %,d", n));
        this.length = n;
        this.type = n2;
    }

    public int getType() {
        return this.type;
    }

    public int getLength() {
        return this.length;
    }

    public int hashCode() {
        return (this.type + 31) * 31 + this.length;
    }

    public boolean equals(Object object) {
        if (object instanceof ExtendedTypeHeader) {
            ExtendedTypeHeader extendedTypeHeader = (ExtendedTypeHeader)object;
            return this.type == extendedTypeHeader.type && this.length == extendedTypeHeader.length;
        }
        return false;
    }

    public String toString() {
        return String.format("ExtendedTypeHeader(type:%d, length:%,d)", this.type, this.length);
    }
}

