/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.impl;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.htrace.core.HTraceConfiguration;
import org.apache.htrace.shaded.commons.logging.Log;
import org.apache.htrace.shaded.commons.logging.LogFactory;
import org.apache.htrace.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.apache.htrace.shaded.fasterxml.jackson.core.JsonProcessingException;
import org.apache.htrace.shaded.fasterxml.jackson.databind.ObjectMapper;
import org.apache.htrace.shaded.fasterxml.jackson.databind.SerializationFeature;

class Conf {
    private static final Log LOG = LogFactory.getLog(Conf.class);
    static final String ADDRESS_KEY = "htraced.receiver.address";
    static final String IO_TIMEOUT_MS_KEY = "htraced.receiver.io.timeout.ms";
    static final int IO_TIMEOUT_MS_DEFAULT = 60000;
    static final int IO_TIMEOUT_MS_MIN = 50;
    static final String CONNECT_TIMEOUT_MS_KEY = "htraced.receiver.connect.timeout.ms";
    static final int CONNECT_TIMEOUT_MS_DEFAULT = 60000;
    static final int CONNECT_TIMEOUT_MS_MIN = 50;
    static final String IDLE_TIMEOUT_MS_KEY = "htraced.receiver.idle.timeout.ms";
    static final int IDLE_TIMEOUT_MS_DEFAULT = 60000;
    static final int IDLE_TIMEOUT_MS_MIN = 0;
    static final String FLUSH_RETRY_DELAYS_KEY = "htraced.flush.retry.delays.key";
    static final String FLUSH_RETRY_DELAYS_DEFAULT = "1000,30000";
    static final String MAX_FLUSH_INTERVAL_MS_KEY = "htraced.receiver.max.flush.interval.ms";
    static final int MAX_FLUSH_INTERVAL_MS_DEFAULT = 60000;
    static final int MAX_FLUSH_INTERVAL_MS_MIN = 10;
    static final String PACKED_KEY = "htraced.receiver.packed";
    static final boolean PACKED_DEFAULT = true;
    static final String BUFFER_SIZE_KEY = "htraced.receiver.buffer.size";
    static final int BUFFER_SIZE_DEFAULT = 0x1000000;
    static int BUFFER_SIZE_MIN = 0x400000;
    static final int BUFFER_SIZE_MAX = 0x2000000;
    static final String BUFFER_SEND_TRIGGER_FRACTION_KEY = "htraced.receiver.buffer.send.trigger.fraction";
    static final double BUFFER_SEND_TRIGGER_FRACTION_DEFAULT = 0.5;
    static final double BUFFER_SEND_TRIGGER_FRACTION_MIN = 0.1;
    static final String SPAN_DROP_TIMEOUT_MS_KEY = "htraced.max.buffer.full.retry.ms.key";
    static final int SPAN_DROP_TIMEOUT_MS_DEFAULT = 5000;
    static final String ERROR_LOG_PERIOD_MS_KEY = "htraced.error.log.period.ms";
    static final long ERROR_LOG_PERIOD_MS_DEFAULT = 30000L;
    static final String DROPPED_SPANS_LOG_PATH_KEY = "htraced.dropped.spans.log.path";
    static final String DROPPED_SPANS_LOG_PATH_DEFAULT = new File(System.getProperty("java.io.tmpdir", "/tmp"), "htraceDropped").getAbsolutePath();
    static final String DROPPED_SPANS_LOG_MAX_SIZE_KEY = "htraced.dropped.spans.log.max.size";
    static final long DROPPED_SPANS_LOG_MAX_SIZE_DEFAULT = 0x100000L;
    @JsonProperty(value="ioTimeoutMs")
    final int ioTimeoutMs;
    @JsonProperty(value="connectTimeoutMs")
    final int connectTimeoutMs;
    @JsonProperty(value="idleTimeoutMs")
    final int idleTimeoutMs;
    @JsonProperty(value="flushRetryDelays")
    final int[] flushRetryDelays;
    @JsonProperty(value="maxFlushIntervalMs")
    final int maxFlushIntervalMs;
    @JsonProperty(value="packed")
    final boolean packed;
    @JsonProperty(value="bufferSize")
    final int bufferSize;
    @JsonProperty(value="spanDropTimeoutMs")
    final int spanDropTimeoutMs;
    @JsonProperty(value="errorLogPeriodMs")
    final long errorLogPeriodMs;
    @JsonProperty(value="triggerSize")
    final int triggerSize;
    @JsonProperty(value="endpointStr")
    final String endpointStr;
    @JsonProperty(value="endpoint")
    final InetSocketAddress endpoint;
    @JsonProperty(value="droppedSpansLogPath")
    final String droppedSpansLogPath;
    @JsonProperty(value="droppedSpansLogMaxSize")
    final long droppedSpansLogMaxSize;

    private static int getBoundedInt(HTraceConfiguration conf, String key, int defaultValue, int minValue, int maxValue) {
        int val = conf.getInt(key, defaultValue);
        if (val < minValue) {
            LOG.warn("Can't set " + key + " to " + val + ".  Using minimum value " + "of " + minValue + " instead.");
            return minValue;
        }
        if (val > maxValue) {
            LOG.warn("Can't set " + key + " to " + val + ".  Using maximum value " + "of " + maxValue + " instead.");
            return maxValue;
        }
        return val;
    }

    private static long getBoundedLong(HTraceConfiguration conf, String key, long defaultValue, long minValue, long maxValue) {
        String strVal = conf.get(key, Long.toString(defaultValue));
        long val = 0L;
        try {
            val = Long.parseLong(strVal);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Bad value for '" + key + "': should be long");
        }
        if (val < minValue) {
            LOG.warn("Can't set " + key + " to " + val + ".  Using minimum value " + "of " + minValue + " instead.");
            return minValue;
        }
        if (val > maxValue) {
            LOG.warn("Can't set " + key + " to " + val + ".  Using maximum value " + "of " + maxValue + " instead.");
            return maxValue;
        }
        return val;
    }

    private static double getBoundedDouble(HTraceConfiguration conf, String key, double defaultValue, double minValue, double maxValue) {
        String strVal = conf.get(key, Double.toString(defaultValue));
        double val = 0.0;
        try {
            val = Double.parseDouble(strVal);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Bad value for '" + key + "': should be double");
        }
        if (val < minValue) {
            LOG.warn("Can't set " + key + " to " + val + ".  Using minimum value " + "of " + minValue + " instead.");
            return minValue;
        }
        if (val > maxValue) {
            LOG.warn("Can't set " + key + " to " + val + ".  Using maximum value " + "of " + maxValue + " instead.");
            return maxValue;
        }
        return val;
    }

    private static int parseColonPort(String portStr) throws IOException {
        int colonPosition = portStr.indexOf(58);
        if (colonPosition != 0) {
            throw new IOException("Invalid port string " + portStr);
        }
        int port = Integer.parseInt(portStr.substring(1), 10);
        if (port < 0 || port > 65535) {
            throw new IOException("Invalid port number " + port);
        }
        return port;
    }

    InetSocketAddress parseHostPortPair(String str) throws IOException {
        if ((str = str.trim()).isEmpty()) {
            throw new IOException("No hostname:port pair given.");
        }
        int bracketBegin = str.indexOf(91);
        if (bracketBegin == 0) {
            int bracketEnd = str.indexOf(93);
            if (bracketEnd < 0) {
                throw new IOException("Found left bracket, but no corresponding right bracket, in " + str);
            }
            String host = str.substring(bracketBegin + 1, bracketEnd);
            int port = Conf.parseColonPort(str.substring(bracketEnd + 1));
            return InetSocketAddress.createUnresolved(host, port);
        }
        if (bracketBegin > 0) {
            throw new IOException("Found a left bracket that wasn't at the start of the host:port pair in " + str);
        }
        int colon = str.indexOf(58);
        if (colon <= 0) {
            throw new IOException("No port component found in " + str);
        }
        String host = str.substring(0, colon);
        int port = Conf.parseColonPort(str.substring(colon));
        return InetSocketAddress.createUnresolved(host, port);
    }

    static int[] getIntArray(String arrayStr) {
        String[] array = arrayStr.split(",");
        int nonEmptyEntries = 0;
        for (String str : array) {
            if (str.trim().isEmpty()) continue;
            ++nonEmptyEntries;
        }
        int[] ret = new int[nonEmptyEntries];
        int i = 0;
        for (String str : array) {
            if (str.trim().isEmpty()) continue;
            ret[i++] = Integer.parseInt(str);
        }
        return ret;
    }

    Conf(HTraceConfiguration conf) throws IOException {
        this.ioTimeoutMs = Conf.getBoundedInt(conf, IO_TIMEOUT_MS_KEY, 60000, 50, Integer.MAX_VALUE);
        this.connectTimeoutMs = Conf.getBoundedInt(conf, CONNECT_TIMEOUT_MS_KEY, 60000, 50, Integer.MAX_VALUE);
        this.idleTimeoutMs = Conf.getBoundedInt(conf, IDLE_TIMEOUT_MS_KEY, 60000, 0, Integer.MAX_VALUE);
        this.flushRetryDelays = Conf.getIntArray(conf.get(FLUSH_RETRY_DELAYS_KEY, FLUSH_RETRY_DELAYS_DEFAULT));
        this.maxFlushIntervalMs = Conf.getBoundedInt(conf, MAX_FLUSH_INTERVAL_MS_KEY, 60000, 10, Integer.MAX_VALUE);
        this.packed = conf.getBoolean(PACKED_KEY, true);
        this.bufferSize = Conf.getBoundedInt(conf, BUFFER_SIZE_KEY, 0x1000000, BUFFER_SIZE_MIN, 0x2000000);
        double triggerFraction = Conf.getBoundedDouble(conf, BUFFER_SEND_TRIGGER_FRACTION_KEY, 0.5, 0.1, 1.0);
        this.spanDropTimeoutMs = conf.getInt(SPAN_DROP_TIMEOUT_MS_KEY, 5000);
        this.errorLogPeriodMs = Conf.getBoundedLong(conf, ERROR_LOG_PERIOD_MS_KEY, 30000L, 0L, Long.MAX_VALUE);
        this.triggerSize = (int)((double)this.bufferSize * triggerFraction);
        try {
            this.endpointStr = conf.get(ADDRESS_KEY, "");
            this.endpoint = this.parseHostPortPair(this.endpointStr);
        }
        catch (IOException e) {
            throw new IOException("Error reading htraced.receiver.address: " + e.getMessage());
        }
        this.droppedSpansLogPath = conf.get(DROPPED_SPANS_LOG_PATH_KEY, DROPPED_SPANS_LOG_PATH_DEFAULT);
        this.droppedSpansLogMaxSize = Conf.getBoundedLong(conf, DROPPED_SPANS_LOG_MAX_SIZE_KEY, 0x100000L, 0L, Long.MAX_VALUE);
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        try {
            return mapper.writeValueAsString(this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

