/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.shaded.jetty.util.log;

import java.util.logging.Level;
import org.apache.htrace.shaded.jetty.util.log.AbstractLogger;
import org.apache.htrace.shaded.jetty.util.log.Log;
import org.apache.htrace.shaded.jetty.util.log.Logger;

public class JavaUtilLog
extends AbstractLogger {
    private Level configuredLevel;
    private java.util.logging.Logger _logger;

    public JavaUtilLog() {
        this("org.apache.htrace.shaded.jetty.util.log");
    }

    public JavaUtilLog(String name) {
        this._logger = java.util.logging.Logger.getLogger(name);
        if (Boolean.parseBoolean(Log.__props.getProperty("org.apache.htrace.shaded.jetty.util.log.DEBUG", "false"))) {
            this._logger.setLevel(Level.FINE);
        }
        this.configuredLevel = this._logger.getLevel();
    }

    @Override
    public String getName() {
        return this._logger.getName();
    }

    @Override
    public void warn(String msg, Object ... args) {
        if (this._logger.isLoggable(Level.WARNING)) {
            this._logger.log(Level.WARNING, this.format(msg, args));
        }
    }

    @Override
    public void warn(Throwable thrown) {
        this.warn("", thrown);
    }

    @Override
    public void warn(String msg, Throwable thrown) {
        this._logger.log(Level.WARNING, msg, thrown);
    }

    @Override
    public void info(String msg, Object ... args) {
        if (this._logger.isLoggable(Level.INFO)) {
            this._logger.log(Level.INFO, this.format(msg, args));
        }
    }

    @Override
    public void info(Throwable thrown) {
        this.info("", thrown);
    }

    @Override
    public void info(String msg, Throwable thrown) {
        this._logger.log(Level.INFO, msg, thrown);
    }

    @Override
    public boolean isDebugEnabled() {
        return this._logger.isLoggable(Level.FINE);
    }

    @Override
    public void setDebugEnabled(boolean enabled) {
        if (enabled) {
            this.configuredLevel = this._logger.getLevel();
            this._logger.setLevel(Level.FINE);
        } else {
            this._logger.setLevel(this.configuredLevel);
        }
    }

    @Override
    public void debug(String msg, Object ... args) {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, this.format(msg, args));
        }
    }

    @Override
    public void debug(String msg, long arg) {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, this.format(msg, arg));
        }
    }

    @Override
    public void debug(Throwable thrown) {
        this.debug("", thrown);
    }

    @Override
    public void debug(String msg, Throwable thrown) {
        this._logger.log(Level.FINE, msg, thrown);
    }

    @Override
    protected Logger newLogger(String fullname) {
        return new JavaUtilLog(fullname);
    }

    @Override
    public void ignore(Throwable ignored) {
        if (Log.isIgnored()) {
            this.warn("IGNORED ", ignored);
        }
    }

    private String format(String msg, Object ... args) {
        msg = String.valueOf(msg);
        String braces = "{}";
        StringBuilder builder = new StringBuilder();
        int start = 0;
        for (Object arg : args) {
            int bracesIndex = msg.indexOf(braces, start);
            if (bracesIndex < 0) {
                builder.append(msg.substring(start));
                builder.append(" ");
                builder.append(arg);
                start = msg.length();
                continue;
            }
            builder.append(msg.substring(start, bracesIndex));
            builder.append(String.valueOf(arg));
            start = bracesIndex + braces.length();
        }
        builder.append(msg.substring(start));
        return builder.toString();
    }
}

