/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.shaded.jetty.client.http;

import java.io.IOException;
import java.util.Map;
import org.apache.htrace.shaded.jetty.client.AbstractHttpClientTransport;
import org.apache.htrace.shaded.jetty.client.HttpDestination;
import org.apache.htrace.shaded.jetty.client.Origin;
import org.apache.htrace.shaded.jetty.client.http.HttpConnectionOverHTTP;
import org.apache.htrace.shaded.jetty.client.http.HttpDestinationOverHTTP;
import org.apache.htrace.shaded.jetty.io.Connection;
import org.apache.htrace.shaded.jetty.io.EndPoint;
import org.apache.htrace.shaded.jetty.util.Promise;

public class HttpClientTransportOverHTTP
extends AbstractHttpClientTransport {
    public HttpClientTransportOverHTTP() {
        this(Math.max(1, Runtime.getRuntime().availableProcessors() / 2));
    }

    public HttpClientTransportOverHTTP(int selectors) {
        super(selectors);
    }

    @Override
    public HttpDestination newHttpDestination(Origin origin) {
        return new HttpDestinationOverHTTP(this.getHttpClient(), origin);
    }

    @Override
    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        HttpDestination destination = (HttpDestination)context.get("http.destination");
        HttpConnectionOverHTTP connection = new HttpConnectionOverHTTP(endPoint, destination);
        Promise promise = (Promise)context.get("http.connection.promise");
        promise.succeeded(connection);
        return connection;
    }
}

