/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.shaded.jetty.client;

import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.htrace.shaded.jetty.client.HttpClient;
import org.apache.htrace.shaded.jetty.client.HttpDestination;
import org.apache.htrace.shaded.jetty.client.HttpExchange;
import org.apache.htrace.shaded.jetty.client.HttpRequest;
import org.apache.htrace.shaded.jetty.client.ProxyConfiguration;
import org.apache.htrace.shaded.jetty.client.TimeoutCompleteListener;
import org.apache.htrace.shaded.jetty.client.api.Authentication;
import org.apache.htrace.shaded.jetty.client.api.Connection;
import org.apache.htrace.shaded.jetty.client.api.ContentProvider;
import org.apache.htrace.shaded.jetty.client.api.Request;
import org.apache.htrace.shaded.jetty.client.api.Response;
import org.apache.htrace.shaded.jetty.http.HttpField;
import org.apache.htrace.shaded.jetty.http.HttpFields;
import org.apache.htrace.shaded.jetty.http.HttpHeader;
import org.apache.htrace.shaded.jetty.http.HttpHeaderValue;
import org.apache.htrace.shaded.jetty.http.HttpMethod;
import org.apache.htrace.shaded.jetty.http.HttpVersion;

public abstract class HttpConnection
implements Connection {
    private static final HttpField CHUNKED_FIELD = new HttpField(HttpHeader.TRANSFER_ENCODING, HttpHeaderValue.CHUNKED);
    private final HttpDestination destination;

    protected HttpConnection(HttpDestination destination) {
        this.destination = destination;
    }

    public HttpClient getHttpClient() {
        return this.destination.getHttpClient();
    }

    public HttpDestination getHttpDestination() {
        return this.destination;
    }

    @Override
    public void send(Request request, Response.CompleteListener listener) {
        ArrayList<Response.ResponseListener> listeners = new ArrayList<Response.ResponseListener>(2);
        if (request.getTimeout() > 0L) {
            TimeoutCompleteListener timeoutListener = new TimeoutCompleteListener(request);
            timeoutListener.schedule(this.getHttpClient().getScheduler());
            listeners.add(timeoutListener);
        }
        if (listener != null) {
            listeners.add(listener);
        }
        HttpExchange exchange = new HttpExchange(this.getHttpDestination(), (HttpRequest)request, listeners);
        this.send(exchange);
    }

    protected abstract void send(HttpExchange var1);

    protected void normalizeRequest(Request request) {
        Authentication.Result authnResult;
        URI authenticationURI;
        CookieStore cookieStore;
        String method = request.getMethod();
        HttpVersion version = request.getVersion();
        HttpFields headers = request.getHeaders();
        ContentProvider content = request.getContent();
        ProxyConfiguration.Proxy proxy = this.destination.getProxy();
        String path = request.getPath();
        if (path.trim().length() == 0) {
            path = "/";
            request.path(path);
        }
        if (proxy != null && !HttpMethod.CONNECT.is(method)) {
            path = request.getURI().toString();
            request.path(path);
        }
        if (version.getVersion() > 10 && !headers.containsKey(HttpHeader.HOST.asString())) {
            headers.put(this.getHttpDestination().getHostField());
        }
        if (content != null) {
            long contentLength;
            String contentType;
            if (content instanceof ContentProvider.Typed && !headers.containsKey(HttpHeader.CONTENT_TYPE.asString()) && (contentType = ((ContentProvider.Typed)content).getContentType()) != null) {
                headers.put(HttpHeader.CONTENT_TYPE, contentType);
            }
            if ((contentLength = content.getLength()) >= 0L) {
                if (!headers.containsKey(HttpHeader.CONTENT_LENGTH.asString())) {
                    headers.put(HttpHeader.CONTENT_LENGTH, String.valueOf(contentLength));
                }
            } else if (!headers.containsKey(HttpHeader.TRANSFER_ENCODING.asString())) {
                headers.put(CHUNKED_FIELD);
            }
        }
        if ((cookieStore = this.getHttpClient().getCookieStore()) != null) {
            StringBuilder cookies = this.convertCookies(cookieStore.get(request.getURI()), null);
            cookies = this.convertCookies(request.getCookies(), cookies);
            if (cookies != null) {
                request.header(HttpHeader.COOKIE.asString(), cookies.toString());
            }
        }
        URI uRI = authenticationURI = proxy != null ? proxy.getURI() : request.getURI();
        if (authenticationURI != null && (authnResult = this.getHttpClient().getAuthenticationStore().findAuthenticationResult(authenticationURI)) != null) {
            authnResult.apply(request);
        }
    }

    private StringBuilder convertCookies(List<HttpCookie> cookies, StringBuilder builder) {
        for (int i = 0; i < cookies.size(); ++i) {
            if (builder == null) {
                builder = new StringBuilder();
            }
            if (builder.length() > 0) {
                builder.append("; ");
            }
            HttpCookie cookie = cookies.get(i);
            builder.append(cookie.getName()).append("=").append(cookie.getValue());
        }
        return builder;
    }

    public String toString() {
        return String.format("%s@%h", this.getClass().getSimpleName(), this);
    }
}

