/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.msgpack.value.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.htrace.msgpack.core.MessagePack;
import org.apache.htrace.msgpack.core.MessagePacker;
import org.apache.htrace.msgpack.core.MessageStringCodingException;
import org.apache.htrace.msgpack.core.buffer.MessageBuffer;
import org.apache.htrace.msgpack.value.StringValue;
import org.apache.htrace.msgpack.value.Value;
import org.apache.htrace.msgpack.value.ValueFactory;
import org.apache.htrace.msgpack.value.ValueType;
import org.apache.htrace.msgpack.value.ValueVisitor;
import org.apache.htrace.msgpack.value.impl.AbstractValue;

public class StringValueImpl
extends AbstractValue
implements StringValue {
    private final String value;

    public StringValueImpl(String string) {
        this.value = string;
    }

    @Override
    public ValueType getValueType() {
        return ValueType.STRING;
    }

    @Override
    public byte[] toByteArray() {
        return this.value.getBytes(MessagePack.UTF8);
    }

    @Override
    public MessageBuffer toMessageBuffer() {
        return MessageBuffer.wrap(this.toByteArray());
    }

    @Override
    public String toString() {
        return this.value;
    }

    @Override
    public ByteBuffer toByteBuffer() {
        return this.toMessageBuffer().toByteBuffer();
    }

    @Override
    public void writeTo(MessagePacker messagePacker) throws IOException {
        messagePacker.packString(this.value);
    }

    @Override
    public void accept(ValueVisitor valueVisitor) {
        valueVisitor.visitString(this);
    }

    @Override
    public StringValue toValue() {
        return ValueFactory.newString(this.value);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Value)) {
            return false;
        }
        Value value = (Value)object;
        if (!value.isString()) {
            return false;
        }
        try {
            return value.asString().toString().equals(this.value);
        }
        catch (MessageStringCodingException messageStringCodingException) {
            return false;
        }
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

