/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.msgpack.value.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.htrace.msgpack.core.MessagePacker;
import org.apache.htrace.msgpack.core.MessageStringCodingException;
import org.apache.htrace.msgpack.core.buffer.MessageBuffer;
import org.apache.htrace.msgpack.value.BinaryValue;
import org.apache.htrace.msgpack.value.RawValue;
import org.apache.htrace.msgpack.value.Value;
import org.apache.htrace.msgpack.value.impl.AbstractValue;

public abstract class RawValueImpl
extends AbstractValue
implements RawValue {
    protected final ByteBuffer byteBuffer;
    private transient String decodedStringCache;
    private transient MessageStringCodingException codingException;

    public RawValueImpl(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer.slice();
    }

    @Override
    public byte[] toByteArray() {
        byte[] byArray = new byte[this.byteBuffer.remaining()];
        this.byteBuffer.slice().get(byArray);
        return byArray;
    }

    @Override
    public RawValue toValue() {
        return this;
    }

    @Override
    public ByteBuffer toByteBuffer() {
        return this.byteBuffer.asReadOnlyBuffer();
    }

    @Override
    public MessageBuffer toMessageBuffer() {
        return MessageBuffer.wrap(this.byteBuffer);
    }

    @Override
    public String toString() {
        if (this.decodedStringCache == null) {
            this.decodeString();
        }
        if (this.codingException != null) {
            throw this.codingException;
        }
        return this.decodedStringCache;
    }

    private synchronized void decodeString() {
        if (this.decodedStringCache != null) {
            return;
        }
        ByteBuffer byteBuffer = this.byteBuffer.asReadOnlyBuffer();
        try {
            CharsetDecoder charsetDecoder = Charset.forName("UTF-8").newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            byteBuffer.position(0);
            this.decodedStringCache = charsetDecoder.decode(byteBuffer).toString();
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            throw new AssertionError((Object)unsupportedCharsetException);
        }
        catch (CharacterCodingException characterCodingException) {
            this.codingException = new MessageStringCodingException(characterCodingException);
            try {
                CharsetDecoder charsetDecoder = Charset.forName("UTF-8").newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
                byteBuffer.position(0);
                this.decodedStringCache = charsetDecoder.decode(byteBuffer).toString();
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                throw new AssertionError((Object)unsupportedCharsetException);
            }
            catch (CharacterCodingException characterCodingException2) {
                throw new AssertionError((Object)characterCodingException2);
            }
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Value)) {
            return false;
        }
        Value value = (Value)object;
        if (!value.isBinary()) {
            return false;
        }
        BinaryValue binaryValue = value.asBinary();
        return binaryValue.toByteBuffer().equals(this.byteBuffer);
    }

    public int hashCode() {
        return this.byteBuffer.hashCode();
    }

    @Override
    public void writeTo(MessagePacker messagePacker) throws IOException {
        messagePacker.packBinaryHeader(this.byteBuffer.remaining());
        messagePacker.writePayload(this.byteBuffer);
    }
}

