/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.msgpack.value.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.htrace.msgpack.core.MessagePacker;
import org.apache.htrace.msgpack.core.MessageStringCodingException;
import org.apache.htrace.msgpack.value.StringValue;
import org.apache.htrace.msgpack.value.Value;
import org.apache.htrace.msgpack.value.ValueType;
import org.apache.htrace.msgpack.value.ValueVisitor;
import org.apache.htrace.msgpack.value.impl.RawValueImpl;

public class RawStringValueImpl
extends RawValueImpl
implements StringValue {
    public RawStringValueImpl(ByteBuffer byteBuffer) {
        super(byteBuffer);
    }

    @Override
    public ValueType getValueType() {
        return ValueType.STRING;
    }

    @Override
    public void accept(ValueVisitor valueVisitor) {
        valueVisitor.visitString(this);
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public void writeTo(MessagePacker messagePacker) throws IOException {
        messagePacker.packRawStringHeader(this.byteBuffer.remaining());
        messagePacker.writePayload(this.byteBuffer);
    }

    @Override
    public StringValue toValue() {
        return this;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Value)) {
            return false;
        }
        Value value = (Value)object;
        if (!value.isString()) {
            return false;
        }
        try {
            return this.toString().equals(value.asString().toString());
        }
        catch (MessageStringCodingException messageStringCodingException) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }
}

