/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.msgpack.value.impl;

import java.io.IOException;
import java.math.BigInteger;
import org.apache.htrace.msgpack.core.MessageIntegerOverflowException;
import org.apache.htrace.msgpack.core.MessagePacker;
import org.apache.htrace.msgpack.value.IntegerValue;
import org.apache.htrace.msgpack.value.Value;
import org.apache.htrace.msgpack.value.ValueType;
import org.apache.htrace.msgpack.value.ValueVisitor;
import org.apache.htrace.msgpack.value.impl.AbstractValue;

public class LongValueImpl
extends AbstractValue
implements IntegerValue {
    private final long value;
    private static final long BYTE_MIN = -128L;
    private static final long BYTE_MAX = 127L;
    private static final long SHORT_MIN = -32768L;
    private static final long SHORT_MAX = 32767L;
    private static final long INT_MIN = Integer.MIN_VALUE;
    private static final long INT_MAX = Integer.MAX_VALUE;

    public LongValueImpl(long l) {
        this.value = l;
    }

    @Override
    public ValueType getValueType() {
        return ValueType.INTEGER;
    }

    @Override
    public IntegerValue asInteger() {
        return this;
    }

    @Override
    public byte toByte() {
        return (byte)this.value;
    }

    @Override
    public short toShort() {
        return (short)this.value;
    }

    @Override
    public int toInt() {
        return (int)this.value;
    }

    @Override
    public long toLong() {
        return this.value;
    }

    @Override
    public BigInteger toBigInteger() {
        return BigInteger.valueOf(this.value);
    }

    @Override
    public float toFloat() {
        return this.value;
    }

    @Override
    public double toDouble() {
        return this.value;
    }

    @Override
    public byte asByte() throws MessageIntegerOverflowException {
        if (!this.isValidByte()) {
            throw new MessageIntegerOverflowException(this.value);
        }
        return (byte)this.value;
    }

    @Override
    public short asShort() throws MessageIntegerOverflowException {
        if (!this.isValidShort()) {
            throw new MessageIntegerOverflowException(this.value);
        }
        return (short)this.value;
    }

    @Override
    public int asInt() throws MessageIntegerOverflowException {
        if (!this.isValidInt()) {
            throw new MessageIntegerOverflowException(this.value);
        }
        return (int)this.value;
    }

    @Override
    public long asLong() throws MessageIntegerOverflowException {
        return this.value;
    }

    @Override
    public BigInteger asBigInteger() throws MessageIntegerOverflowException {
        return BigInteger.valueOf(this.value);
    }

    @Override
    public boolean isValidByte() {
        return -128L <= this.value && this.value <= 127L;
    }

    @Override
    public boolean isValidShort() {
        return -32768L <= this.value && this.value <= 32767L;
    }

    @Override
    public boolean isValidInt() {
        return Integer.MIN_VALUE <= this.value && this.value <= Integer.MAX_VALUE;
    }

    @Override
    public boolean isValidLong() {
        return true;
    }

    @Override
    public boolean isWhole() {
        return true;
    }

    @Override
    public void writeTo(MessagePacker messagePacker) throws IOException {
        messagePacker.packLong(this.value);
    }

    @Override
    public void accept(ValueVisitor valueVisitor) {
        valueVisitor.visitInteger(this);
    }

    @Override
    public IntegerValue toValue() {
        return this;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Value)) {
            return false;
        }
        Value value = (Value)object;
        if (!value.isInteger()) {
            return false;
        }
        IntegerValue integerValue = value.asInteger();
        if (!integerValue.isValidLong()) {
            return false;
        }
        return this.value == integerValue.toLong();
    }

    public int hashCode() {
        if (Integer.MIN_VALUE <= this.value && this.value <= Integer.MAX_VALUE) {
            return (int)this.value;
        }
        return (int)(this.value ^ this.value >>> 32);
    }

    public String toString() {
        return Long.toString(this.value);
    }
}

