/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.msgpack.value.impl;

import java.io.IOException;
import java.math.BigInteger;
import org.apache.htrace.msgpack.core.MessageIntegerOverflowException;
import org.apache.htrace.msgpack.core.MessageOverflowException;
import org.apache.htrace.msgpack.core.MessagePacker;
import org.apache.htrace.msgpack.value.IntegerValue;
import org.apache.htrace.msgpack.value.Value;
import org.apache.htrace.msgpack.value.ValueType;
import org.apache.htrace.msgpack.value.ValueVisitor;
import org.apache.htrace.msgpack.value.impl.AbstractValue;

public class IntegerValueImpl
extends AbstractValue
implements IntegerValue {
    private final int value;
    private static int BYTE_MIN = -128;
    private static int BYTE_MAX = 127;
    private static int SHORT_MIN = Short.MIN_VALUE;
    private static int SHORT_MAX = Short.MAX_VALUE;

    public IntegerValueImpl(int n) {
        this.value = n;
    }

    @Override
    public ValueType getValueType() {
        return ValueType.INTEGER;
    }

    @Override
    public IntegerValue asInteger() {
        return this;
    }

    @Override
    public byte toByte() {
        return (byte)this.value;
    }

    @Override
    public short toShort() {
        return (short)this.value;
    }

    @Override
    public int toInt() {
        return this.value;
    }

    @Override
    public long toLong() {
        return this.value;
    }

    @Override
    public BigInteger toBigInteger() {
        return BigInteger.valueOf(this.value);
    }

    @Override
    public float toFloat() {
        return this.value;
    }

    @Override
    public double toDouble() {
        return this.value;
    }

    @Override
    public byte asByte() throws MessageOverflowException {
        if (!this.isValidByte()) {
            throw new MessageIntegerOverflowException(this.value);
        }
        return (byte)this.value;
    }

    @Override
    public short asShort() throws MessageOverflowException {
        if (!this.isValidShort()) {
            throw new MessageIntegerOverflowException(this.value);
        }
        return (short)this.value;
    }

    @Override
    public int asInt() throws MessageOverflowException {
        return this.value;
    }

    @Override
    public long asLong() throws MessageOverflowException {
        return this.value;
    }

    @Override
    public BigInteger asBigInteger() throws MessageOverflowException {
        return BigInteger.valueOf(this.value);
    }

    @Override
    public boolean isValidByte() {
        return BYTE_MIN <= this.value && this.value <= BYTE_MAX;
    }

    @Override
    public boolean isValidShort() {
        return SHORT_MIN <= this.value && this.value <= SHORT_MAX;
    }

    @Override
    public boolean isValidInt() {
        return true;
    }

    @Override
    public boolean isValidLong() {
        return true;
    }

    @Override
    public boolean isWhole() {
        return true;
    }

    @Override
    public void writeTo(MessagePacker messagePacker) throws IOException {
        messagePacker.packInt(this.value);
    }

    @Override
    public void accept(ValueVisitor valueVisitor) {
        valueVisitor.visitInteger(this);
    }

    @Override
    public IntegerValue toValue() {
        return this;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Value)) {
            return false;
        }
        Value value = (Value)object;
        if (!value.isInteger()) {
            return false;
        }
        IntegerValue integerValue = value.asInteger();
        if (!integerValue.isValidInt()) {
            return false;
        }
        return integerValue.toInt() == this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        return Integer.toString(this.value);
    }
}

