/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.msgpack.value.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.htrace.msgpack.core.MessagePacker;
import org.apache.htrace.msgpack.value.ExtendedValue;
import org.apache.htrace.msgpack.value.ValueType;
import org.apache.htrace.msgpack.value.ValueVisitor;
import org.apache.htrace.msgpack.value.impl.RawValueImpl;

public class ExtendedValueImpl
extends RawValueImpl
implements ExtendedValue {
    private final int type;

    public ExtendedValueImpl(int n, ByteBuffer byteBuffer) {
        super(byteBuffer);
        this.type = n;
    }

    @Override
    public ValueType getValueType() {
        return ValueType.EXTENDED;
    }

    @Override
    public void writeTo(MessagePacker messagePacker) throws IOException {
        messagePacker.packExtendedTypeHeader(this.type, this.byteBuffer.remaining());
        messagePacker.writePayload(this.byteBuffer);
    }

    @Override
    public void accept(ValueVisitor valueVisitor) {
        valueVisitor.visitExtended(this);
    }

    @Override
    public ExtendedValue toValue() {
        return this;
    }

    @Override
    public int getExtType() {
        return this.type;
    }
}

