/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.msgpack.value.impl;

import java.io.IOException;
import java.util.Iterator;
import org.apache.htrace.msgpack.core.MessageFormatException;
import org.apache.htrace.msgpack.core.MessagePackException;
import org.apache.htrace.msgpack.core.MessagePacker;
import org.apache.htrace.msgpack.core.MessageTypeException;
import org.apache.htrace.msgpack.core.MessageUnpacker;
import org.apache.htrace.msgpack.value.ArrayCursor;
import org.apache.htrace.msgpack.value.ArrayValue;
import org.apache.htrace.msgpack.value.Value;
import org.apache.htrace.msgpack.value.ValueFactory;
import org.apache.htrace.msgpack.value.ValueRef;
import org.apache.htrace.msgpack.value.ValueType;
import org.apache.htrace.msgpack.value.ValueVisitor;
import org.apache.htrace.msgpack.value.holder.ValueHolder;
import org.apache.htrace.msgpack.value.impl.AbstractValueRef;

public class ArrayCursorImpl
extends AbstractValueRef
implements ArrayCursor {
    private final ValueHolder valueHolder;
    private MessageUnpacker unpacker;
    private int cursor = 0;
    private int arraySize;

    public ArrayCursorImpl(ValueHolder valueHolder) {
        this.valueHolder = valueHolder;
    }

    public void reset(MessageUnpacker messageUnpacker) throws IOException {
        this.unpacker = messageUnpacker;
        this.arraySize = messageUnpacker.unpackArrayHeader();
        this.cursor = 0;
    }

    @Override
    public int size() {
        return this.arraySize;
    }

    @Override
    public Iterator<ValueRef> iterator() {
        return new Iterator<ValueRef>(){

            @Override
            public boolean hasNext() {
                return ArrayCursorImpl.this.hasNext();
            }

            @Override
            public ValueRef next() {
                return ArrayCursorImpl.this.next();
            }

            @Override
            public void remove() {
                throw MessagePackException.UNSUPPORTED("remove");
            }
        };
    }

    @Override
    public boolean hasNext() {
        return this.cursor < this.arraySize;
    }

    @Override
    public ValueRef next() {
        try {
            this.unpacker.unpackValue(this.valueHolder);
            ++this.cursor;
            return this.valueHolder.getRef();
        }
        catch (IOException iOException) {
            throw new MessageFormatException(iOException);
        }
    }

    @Override
    public void skip() {
        try {
            this.unpacker.skipValue();
            ++this.cursor;
        }
        catch (IOException iOException) {
            throw new MessageFormatException(iOException);
        }
    }

    @Override
    public void skipAll() {
        while (this.hasNext()) {
            this.skip();
        }
    }

    private void ensureNotTraversed() {
        if (this.cursor != 0) {
            throw MessagePackException.UNSUPPORTED("ArrayCursor is already traversed");
        }
    }

    @Override
    public ValueType getValueType() {
        return ValueType.ARRAY;
    }

    @Override
    public ArrayCursor getArrayCursor() throws MessageTypeException {
        return this;
    }

    @Override
    public void writeTo(MessagePacker messagePacker) throws IOException {
        this.ensureNotTraversed();
        messagePacker.packArrayHeader(this.arraySize);
        for (ValueRef valueRef : this) {
            messagePacker.packValue(valueRef.toValue());
        }
    }

    @Override
    public void accept(ValueVisitor valueVisitor) {
        valueVisitor.visitArray(this.toValue());
    }

    @Override
    public ArrayValue toValue() {
        Value[] valueArray = new Value[this.arraySize];
        int n = 0;
        for (ValueRef valueRef : this) {
            valueArray[n++] = valueRef.toValue();
        }
        return ValueFactory.newArray(valueArray);
    }
}

