/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.msgpack.value.holder;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.htrace.msgpack.core.MessagePackException;
import org.apache.htrace.msgpack.core.MessageUnpacker;
import org.apache.htrace.msgpack.core.buffer.MessageBuffer;
import org.apache.htrace.msgpack.value.Value;
import org.apache.htrace.msgpack.value.ValueFactory;
import org.apache.htrace.msgpack.value.ValueRef;
import org.apache.htrace.msgpack.value.ValueType;
import org.apache.htrace.msgpack.value.holder.ExtHolder;
import org.apache.htrace.msgpack.value.holder.FloatHolder;
import org.apache.htrace.msgpack.value.holder.IntegerHolder;
import org.apache.htrace.msgpack.value.holder.RawHolder;
import org.apache.htrace.msgpack.value.impl.ArrayCursorImpl;
import org.apache.htrace.msgpack.value.impl.MapCursorImpl;

public class ValueHolder {
    private ValueType vt;
    private IntegerHolder integerHolder = new IntegerHolder();
    private FloatHolder floatHolder = new FloatHolder();
    private RawHolder rawHolder = new RawHolder();
    private ExtHolder extHolder = new ExtHolder();
    private ArrayCursorImpl arrayCursor;
    private MapCursorImpl mapCursor;
    private ValueRef currentRef;

    public ValueRef getRef() {
        if (this.currentRef == null) {
            throw new IllegalStateException("no value is set to this holder");
        }
        return this.currentRef;
    }

    public Value get() {
        switch (this.vt) {
            case NIL: 
            case BOOLEAN: 
            case INTEGER: 
            case FLOAT: 
            case ARRAY: 
            case MAP: 
            case EXTENDED: {
                return this.getRef().toValue();
            }
            case STRING: {
                return ValueFactory.newRawString(ValueHolder.cloneBuffer(this.rawHolder.getBuffer()));
            }
            case BINARY: {
                return ValueFactory.newBinary(ValueHolder.cloneBuffer(this.rawHolder.getBuffer()));
            }
        }
        throw MessagePackException.UNREACHABLE;
    }

    private static ByteBuffer cloneBuffer(MessageBuffer messageBuffer) {
        return ByteBuffer.wrap(messageBuffer.toByteArray());
    }

    public IntegerHolder getIntegerHolder() {
        return this.integerHolder;
    }

    public FloatHolder getFloatHolder() {
        return this.floatHolder;
    }

    public void setBoolean(boolean bl) {
        this.vt = ValueType.BOOLEAN;
        this.currentRef = ValueFactory.newBoolean(bl);
    }

    public void setNil() {
        this.vt = ValueType.NIL;
        this.currentRef = ValueFactory.nilValue();
    }

    public void setString(MessageBuffer messageBuffer) {
        this.vt = ValueType.STRING;
        this.rawHolder.setString(messageBuffer);
        this.currentRef = this.rawHolder.asString();
    }

    public void setBinary(MessageBuffer messageBuffer) {
        this.vt = ValueType.BINARY;
        this.rawHolder.setBinary(messageBuffer);
        this.currentRef = this.rawHolder.asBinary();
    }

    public void setToInteger() {
        this.vt = ValueType.INTEGER;
        this.currentRef = this.integerHolder;
    }

    public void setToFloat() {
        this.vt = ValueType.FLOAT;
        this.currentRef = this.floatHolder;
    }

    public void setExt(int n, MessageBuffer messageBuffer) {
        this.vt = ValueType.EXTENDED;
        this.extHolder.setExtType(n, messageBuffer);
        this.currentRef = this.extHolder;
    }

    public void prepareArrayCursor(MessageUnpacker messageUnpacker) throws IOException {
        this.vt = ValueType.ARRAY;
        this.arrayCursor = new ArrayCursorImpl(new ValueHolder());
        this.arrayCursor.reset(messageUnpacker);
        this.currentRef = this.arrayCursor;
    }

    public void prepareMapCursor(MessageUnpacker messageUnpacker) throws IOException {
        this.vt = ValueType.MAP;
        this.mapCursor = new MapCursorImpl(new ValueHolder());
        this.mapCursor.reset(messageUnpacker);
        this.currentRef = this.mapCursor;
    }
}

