/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.msgpack.value.holder;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.htrace.msgpack.core.MessagePack;
import org.apache.htrace.msgpack.core.MessagePackException;
import org.apache.htrace.msgpack.core.MessagePacker;
import org.apache.htrace.msgpack.core.MessageStringCodingException;
import org.apache.htrace.msgpack.core.buffer.MessageBuffer;
import org.apache.htrace.msgpack.value.BinaryValue;
import org.apache.htrace.msgpack.value.RawValue;
import org.apache.htrace.msgpack.value.StringValue;
import org.apache.htrace.msgpack.value.ValueFactory;
import org.apache.htrace.msgpack.value.ValueType;
import org.apache.htrace.msgpack.value.ValueVisitor;
import org.apache.htrace.msgpack.value.holder.RawHolderImpl;

public class RawHolder
extends RawHolderImpl {
    private StringValueWrap stringWrap = new StringValueWrap();
    private BinaryValueWrap binaryWrap = new BinaryValueWrap();

    @Override
    public void setString(MessageBuffer messageBuffer) {
        this.tpe = RawHolderImpl.Type.STRING;
        this.buf = messageBuffer;
        this.stringWrap.setString(messageBuffer);
    }

    @Override
    public void setBinary(MessageBuffer messageBuffer) {
        this.tpe = RawHolderImpl.Type.BINARY;
        this.buf = messageBuffer;
        this.binaryWrap.setBinary(messageBuffer);
    }

    @Override
    public MessageBuffer getBuffer() {
        return this.buf;
    }

    @Override
    public byte[] toByteArray() {
        switch (this.tpe) {
            case STRING: 
            case BINARY: {
                return this.buf.toByteArray();
            }
        }
        throw MessagePackException.UNREACHABLE;
    }

    @Override
    public ByteBuffer toByteBuffer() {
        switch (this.tpe) {
            case STRING: {
                return this.buf.toByteBuffer();
            }
        }
        throw MessagePackException.UNREACHABLE;
    }

    @Override
    public MessageBuffer toMessageBuffer() {
        return this.buf;
    }

    @Override
    public String toString() throws MessageStringCodingException {
        switch (this.tpe) {
            case STRING: {
                return new String(this.buf.toByteArray(), MessagePack.UTF8);
            }
            case BINARY: {
                return this.buf.toHexString(0, this.buf.size());
            }
        }
        throw MessagePackException.UNREACHABLE;
    }

    @Override
    public ValueType getValueType() {
        switch (this.tpe) {
            case STRING: {
                return ValueType.STRING;
            }
            case BINARY: {
                return ValueType.BINARY;
            }
        }
        throw MessagePackException.UNREACHABLE;
    }

    @Override
    public void writeTo(MessagePacker messagePacker) throws IOException {
        switch (this.tpe) {
            case STRING: {
                messagePacker.packRawStringHeader(this.buf.size()).writePayload(this.buf.toByteBuffer());
                break;
            }
            case BINARY: {
                messagePacker.packBinaryHeader(this.buf.size()).writePayload(this.buf.toByteBuffer());
                break;
            }
            default: {
                throw MessagePackException.UNREACHABLE;
            }
        }
    }

    @Override
    public void accept(ValueVisitor valueVisitor) {
        switch (this.tpe) {
            case STRING: {
                valueVisitor.visitString(this.asString());
                break;
            }
            case BINARY: {
                valueVisitor.visitBinary(this.asBinary());
                break;
            }
            default: {
                throw MessagePackException.UNREACHABLE;
            }
        }
    }

    @Override
    public RawValue toValue() {
        switch (this.tpe) {
            case STRING: {
                return ValueFactory.newRawString(this.buf.toByteArray());
            }
            case BINARY: {
                return ValueFactory.newBinary(this.buf.toByteArray());
            }
        }
        throw MessagePackException.UNREACHABLE;
    }

    @Override
    public StringValue asString() {
        return this.stringWrap;
    }

    @Override
    public BinaryValue asBinary() {
        return this.binaryWrap;
    }

    private static class BinaryValueWrap
    extends RawHolderImpl
    implements BinaryValue {
        private BinaryValueWrap() {
        }

        @Override
        public BinaryValue toValue() {
            return ValueFactory.newBinary(this.buf.toByteArray());
        }
    }

    private static class StringValueWrap
    extends RawHolderImpl
    implements StringValue {
        private StringValueWrap() {
        }

        @Override
        public StringValue toValue() {
            return ValueFactory.newRawString(this.buf.toByteArray());
        }
    }
}

