/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.msgpack.value.holder;

import java.io.IOException;
import java.math.BigInteger;
import org.apache.htrace.msgpack.core.MessageIntegerOverflowException;
import org.apache.htrace.msgpack.core.MessagePacker;
import org.apache.htrace.msgpack.core.MessageTypeException;
import org.apache.htrace.msgpack.core.NumberUtil;
import org.apache.htrace.msgpack.value.IntegerValue;
import org.apache.htrace.msgpack.value.ValueFactory;
import org.apache.htrace.msgpack.value.ValueType;
import org.apache.htrace.msgpack.value.ValueVisitor;
import org.apache.htrace.msgpack.value.impl.AbstractValueRef;

public class IntegerHolder
extends AbstractValueRef
implements IntegerValue {
    private Type tpe;
    private long longValue;
    private BigInteger biValue;

    @Override
    public ValueType getValueType() {
        return ValueType.INTEGER;
    }

    @Override
    public void writeTo(MessagePacker messagePacker) throws IOException {
        switch (this.tpe) {
            case BIG_INTEGER: {
                messagePacker.packBigInteger(this.biValue);
                break;
            }
            default: {
                messagePacker.packLong(this.longValue);
            }
        }
    }

    @Override
    public IntegerValue asInteger() throws MessageTypeException {
        return this;
    }

    @Override
    public void accept(ValueVisitor valueVisitor) {
        valueVisitor.visitInteger(this);
    }

    @Override
    public IntegerValue toValue() {
        switch (this.tpe) {
            case BYTE: {
                return ValueFactory.newByte(this.toByte());
            }
            case SHORT: {
                return ValueFactory.newShort(this.toShort());
            }
            case INT: {
                return ValueFactory.newInt(this.toInt());
            }
            case LONG: {
                return ValueFactory.newLong(this.toLong());
            }
            case BIG_INTEGER: {
                return ValueFactory.newBigInteger(this.toBigInteger());
            }
        }
        throw new IllegalStateException("cannot reach here");
    }

    public Type getType() {
        return this.tpe;
    }

    public void setByte(byte by) {
        this.tpe = Type.BYTE;
        this.longValue = by;
    }

    public void setShort(short s) {
        this.tpe = Type.SHORT;
        this.longValue = s;
    }

    public void setInt(int n) {
        this.tpe = Type.INT;
        this.longValue = n;
    }

    public void setLong(long l) {
        this.tpe = Type.LONG;
        this.longValue = l;
    }

    public void setBigInteger(BigInteger bigInteger) {
        this.tpe = Type.BIG_INTEGER;
        this.biValue = bigInteger;
    }

    private RuntimeException failure() {
        return new IllegalStateException();
    }

    public boolean isBigInteger() {
        return this.tpe == Type.BIG_INTEGER;
    }

    @Override
    public boolean isValidByte() {
        return this.tpe == Type.BYTE;
    }

    @Override
    public boolean isValidShort() {
        return this.tpe.ordinal() <= Type.SHORT.ordinal();
    }

    @Override
    public boolean isValidInt() {
        return this.tpe.ordinal() <= Type.INT.ordinal();
    }

    @Override
    public boolean isValidLong() {
        return this.tpe.ordinal() <= Type.LONG.ordinal();
    }

    @Override
    public boolean isWhole() {
        return true;
    }

    @Override
    public byte toByte() {
        return this.isBigInteger() ? this.biValue.byteValue() : (byte)this.longValue;
    }

    @Override
    public short toShort() {
        return this.isBigInteger() ? this.biValue.shortValue() : (short)this.longValue;
    }

    @Override
    public int toInt() {
        return this.isBigInteger() ? this.biValue.intValue() : (int)this.longValue;
    }

    @Override
    public long toLong() {
        return this.isBigInteger() ? this.biValue.longValue() : this.longValue;
    }

    @Override
    public BigInteger toBigInteger() {
        return this.isBigInteger() ? this.biValue : BigInteger.valueOf(this.longValue);
    }

    @Override
    public float toFloat() {
        return this.isBigInteger() ? this.biValue.floatValue() : (float)this.longValue;
    }

    @Override
    public double toDouble() {
        return this.isBigInteger() ? this.biValue.doubleValue() : (double)this.longValue;
    }

    @Override
    public byte asByte() throws MessageIntegerOverflowException {
        switch (this.tpe) {
            case BYTE: {
                return (byte)this.longValue;
            }
            case SHORT: 
            case INT: 
            case LONG: {
                if (NumberUtil.LongUtil.isValidByte(this.longValue)) {
                    return (byte)this.longValue;
                }
                throw new MessageIntegerOverflowException(this.longValue);
            }
            case BIG_INTEGER: {
                if (NumberUtil.LongUtil.isValidByte(this.biValue)) {
                    return this.biValue.byteValue();
                }
                throw new MessageIntegerOverflowException(this.biValue);
            }
        }
        throw this.failure();
    }

    @Override
    public short asShort() throws MessageIntegerOverflowException {
        switch (this.tpe) {
            case BYTE: 
            case SHORT: {
                return (short)this.longValue;
            }
            case INT: 
            case LONG: {
                if (NumberUtil.LongUtil.isValidShort(this.longValue)) {
                    return (short)this.longValue;
                }
                throw new MessageIntegerOverflowException(this.longValue);
            }
            case BIG_INTEGER: {
                if (NumberUtil.LongUtil.isValidShort(this.biValue)) {
                    return this.biValue.shortValue();
                }
                throw new MessageIntegerOverflowException(this.biValue);
            }
        }
        throw this.failure();
    }

    @Override
    public int asInt() throws MessageIntegerOverflowException {
        switch (this.tpe) {
            case BYTE: 
            case SHORT: 
            case INT: {
                return (int)this.longValue;
            }
            case LONG: {
                if (NumberUtil.LongUtil.isValidInt(this.longValue)) {
                    return (int)this.longValue;
                }
                throw new MessageIntegerOverflowException(this.longValue);
            }
            case BIG_INTEGER: {
                if (NumberUtil.LongUtil.isValidInt(this.biValue)) {
                    return this.biValue.intValue();
                }
                throw new MessageIntegerOverflowException(this.biValue);
            }
        }
        throw this.failure();
    }

    @Override
    public long asLong() throws MessageIntegerOverflowException {
        if (this.isBigInteger()) {
            if (NumberUtil.LongUtil.isValidLong(this.biValue)) {
                return this.biValue.longValue();
            }
            throw new MessageIntegerOverflowException(this.biValue);
        }
        return this.longValue;
    }

    @Override
    public BigInteger asBigInteger() {
        return this.toBigInteger();
    }

    public int hashCode() {
        return this.isBigInteger() ? this.biValue.hashCode() : (int)this.longValue;
    }

    public String toString() {
        return this.isBigInteger() ? this.biValue.toString() : Long.toString(this.longValue);
    }

    public static enum Type {
        BYTE,
        SHORT,
        INT,
        LONG,
        BIG_INTEGER;

    }
}

