/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.msgpack.value.holder;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.htrace.msgpack.core.MessagePack;
import org.apache.htrace.msgpack.core.MessagePacker;
import org.apache.htrace.msgpack.core.MessageStringCodingException;
import org.apache.htrace.msgpack.core.buffer.MessageBuffer;
import org.apache.htrace.msgpack.value.ExtendedValue;
import org.apache.htrace.msgpack.value.ValueFactory;
import org.apache.htrace.msgpack.value.ValueType;
import org.apache.htrace.msgpack.value.ValueVisitor;
import org.apache.htrace.msgpack.value.impl.AbstractValueRef;

public class ExtHolder
extends AbstractValueRef
implements ExtendedValue {
    private int extType;
    private MessageBuffer buffer;

    public void setExtType(int n, MessageBuffer messageBuffer) {
        this.extType = n;
        this.buffer = messageBuffer;
    }

    @Override
    public int getExtType() {
        return this.extType;
    }

    @Override
    public ValueType getValueType() {
        return ValueType.EXTENDED;
    }

    @Override
    public void writeTo(MessagePacker messagePacker) throws IOException {
        messagePacker.packExtendedTypeHeader(this.extType, this.buffer.size()).writePayload(this.buffer.toByteBuffer());
    }

    @Override
    public void accept(ValueVisitor valueVisitor) {
        valueVisitor.visitExtended(this);
    }

    @Override
    public ExtendedValue toValue() {
        return ValueFactory.newExtendedValue(this.extType, this.buffer.toByteArray());
    }

    @Override
    public byte[] toByteArray() {
        return this.buffer.toByteArray();
    }

    @Override
    public ByteBuffer toByteBuffer() {
        return this.buffer.toByteBuffer();
    }

    @Override
    public MessageBuffer toMessageBuffer() {
        return this.buffer;
    }

    @Override
    public String toString() throws MessageStringCodingException {
        return new String(this.buffer.toByteArray(), MessagePack.UTF8);
    }
}

