/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.msgpack.value;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.htrace.msgpack.value.ArrayValue;
import org.apache.htrace.msgpack.value.BinaryValue;
import org.apache.htrace.msgpack.value.BooleanValue;
import org.apache.htrace.msgpack.value.ExtendedValue;
import org.apache.htrace.msgpack.value.FloatValue;
import org.apache.htrace.msgpack.value.IntegerValue;
import org.apache.htrace.msgpack.value.MapValue;
import org.apache.htrace.msgpack.value.NilValue;
import org.apache.htrace.msgpack.value.StringValue;
import org.apache.htrace.msgpack.value.Value;
import org.apache.htrace.msgpack.value.impl.ArrayValueImpl;
import org.apache.htrace.msgpack.value.impl.BigIntegerValueImpl;
import org.apache.htrace.msgpack.value.impl.BinaryValueImpl;
import org.apache.htrace.msgpack.value.impl.BooleanValueImpl;
import org.apache.htrace.msgpack.value.impl.DoubleValueImpl;
import org.apache.htrace.msgpack.value.impl.ExtendedValueImpl;
import org.apache.htrace.msgpack.value.impl.FloatValueImpl;
import org.apache.htrace.msgpack.value.impl.IntegerValueImpl;
import org.apache.htrace.msgpack.value.impl.LongValueImpl;
import org.apache.htrace.msgpack.value.impl.MapValueImpl;
import org.apache.htrace.msgpack.value.impl.NilValueImpl;
import org.apache.htrace.msgpack.value.impl.RawStringValueImpl;
import org.apache.htrace.msgpack.value.impl.StringValueImpl;

public class ValueFactory {
    public static NilValue nilValue() {
        return NilValueImpl.getInstance();
    }

    public static BooleanValue newBoolean(boolean bl) {
        return bl ? BooleanValueImpl.TRUE : BooleanValueImpl.FALSE;
    }

    public static IntegerValue newByte(byte by) {
        return new IntegerValueImpl(by);
    }

    public static IntegerValue newShort(short s) {
        return new IntegerValueImpl(s);
    }

    public static IntegerValue newInt(int n) {
        return new IntegerValueImpl(n);
    }

    public static IntegerValue newLong(long l) {
        return new LongValueImpl(l);
    }

    public static IntegerValue newBigInteger(BigInteger bigInteger) {
        return new BigIntegerValueImpl(bigInteger);
    }

    public static FloatValue newFloat(float f) {
        return new FloatValueImpl(f);
    }

    public static FloatValue newDouble(double d) {
        return new DoubleValueImpl(d);
    }

    public static BinaryValue newBinary(byte[] byArray) {
        return new BinaryValueImpl(ByteBuffer.wrap(byArray));
    }

    public static BinaryValue newBinary(byte[] byArray, int n, int n2) {
        return new BinaryValueImpl(ByteBuffer.wrap(byArray, n, n2));
    }

    public static BinaryValue newBinary(ByteBuffer byteBuffer) {
        return new BinaryValueImpl(byteBuffer.duplicate());
    }

    public static StringValue newString(String string) {
        return new StringValueImpl(string);
    }

    public static StringValue newRawString(byte[] byArray) {
        return new RawStringValueImpl(ByteBuffer.wrap(byArray));
    }

    public static StringValue newRawString(byte[] byArray, int n, int n2) {
        return new RawStringValueImpl(ByteBuffer.wrap(byArray, n, n2));
    }

    public static StringValue newRawString(ByteBuffer byteBuffer) {
        return new RawStringValueImpl(byteBuffer.duplicate());
    }

    public static ArrayValue newArrayFrom(List<? extends Value> list) {
        if (list.isEmpty()) {
            return ArrayValueImpl.empty();
        }
        Value[] valueArray = list.toArray(new Value[list.size()]);
        return new ArrayValueImpl(valueArray);
    }

    public static ArrayValue newArray(Value ... valueArray) {
        if (valueArray.length == 0) {
            return ArrayValueImpl.empty();
        }
        return new ArrayValueImpl(valueArray);
    }

    public static ArrayValue emptyArray() {
        return ArrayValueImpl.empty();
    }

    public static <K extends Value, V extends Value> MapValue newMap(Map<K, V> map) {
        Value[] valueArray = new Value[map.size() * 2];
        Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Map.Entry<K, V> entry = iterator.next();
            valueArray[n++] = (Value)entry.getKey();
            valueArray[n++] = (Value)entry.getValue();
        }
        return ValueFactory.newMap(valueArray);
    }

    public static MapValue newMap(Value[] valueArray) {
        if (valueArray.length == 0) {
            return MapValueImpl.empty();
        }
        return new MapValueImpl(valueArray);
    }

    public static MapValue emptyMap() {
        return MapValueImpl.empty();
    }

    public static ExtendedValue newExtendedValue(int n, byte[] byArray) {
        return ValueFactory.newExtendedValue(n, ByteBuffer.wrap(byArray));
    }

    public static ExtendedValue newExtendedValue(int n, ByteBuffer byteBuffer) {
        return new ExtendedValueImpl(n, byteBuffer);
    }

    protected ValueFactory() {
    }
}

