/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.msgpack.core.example;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CodingErrorAction;
import org.apache.htrace.msgpack.core.MessageFormat;
import org.apache.htrace.msgpack.core.MessagePack;
import org.apache.htrace.msgpack.core.MessagePacker;
import org.apache.htrace.msgpack.core.MessageUnpacker;
import org.apache.htrace.msgpack.core.buffer.MessageBuffer;
import org.apache.htrace.msgpack.value.ArrayValue;
import org.apache.htrace.msgpack.value.ExtendedValue;
import org.apache.htrace.msgpack.value.Value;
import org.apache.htrace.msgpack.value.ValueRef;
import org.apache.htrace.msgpack.value.holder.FloatHolder;
import org.apache.htrace.msgpack.value.holder.IntegerHolder;
import org.apache.htrace.msgpack.value.holder.ValueHolder;

public class MessagePackExample {
    public static void basicUsage() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        MessagePacker messagePacker = MessagePack.newDefaultPacker(byteArrayOutputStream);
        messagePacker.packInt(1).packString("leo").packArrayHeader(2).packString("xxx-xxxx").packString("yyy-yyyy");
        messagePacker.close();
        MessageUnpacker messageUnpacker = MessagePack.newDefaultUnpacker(byteArrayOutputStream.toByteArray());
        int n = messageUnpacker.unpackInt();
        String string = messageUnpacker.unpackString();
        int n2 = messageUnpacker.unpackArrayHeader();
        String[] stringArray = new String[n2];
        for (int i = 0; i < n2; ++i) {
            stringArray[i] = messageUnpacker.unpackString();
        }
        messageUnpacker.close();
        System.out.println(String.format("id:%d, name:%s, phone:[%s]", n, string, MessagePackExample.join(stringArray)));
    }

    private static String join(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(stringArray[i]);
        }
        return stringBuilder.toString();
    }

    public static void packer() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        MessagePacker messagePacker = MessagePack.newDefaultPacker(byteArrayOutputStream);
        messagePacker.packBoolean(true);
        messagePacker.packShort((short)34);
        messagePacker.packInt(1);
        messagePacker.packLong(33000000000L);
        messagePacker.packFloat(0.1f);
        messagePacker.packDouble(3.14159263);
        messagePacker.packByte((byte)-128);
        messagePacker.packNil();
        messagePacker.packString("hello message pack!");
        byte[] byArray = "utf-8 strings".getBytes(MessagePack.UTF8);
        messagePacker.packRawStringHeader(byArray.length);
        messagePacker.writePayload(byArray);
        int[] nArray = new int[]{3, 5, 1, 0, -1, 255};
        messagePacker.packArrayHeader(nArray.length);
        for (int n : nArray) {
            messagePacker.packInt(n);
        }
        messagePacker.packMapHeader(2);
        messagePacker.packString("apple");
        messagePacker.packInt(1);
        messagePacker.packString("banana");
        messagePacker.packInt(2);
        byte[] byArray2 = new byte[]{1, 2, 3, 4};
        messagePacker.packBinaryHeader(byArray2.length);
        messagePacker.writePayload(byArray2);
        byte[] byArray3 = "custom data type".getBytes(MessagePack.UTF8);
        messagePacker.packExtendedTypeHeader(1, 10);
        messagePacker.writePayload(byArray3);
        messagePacker.packInt(1).packString("leo").packArrayHeader(2).packString("xxx-xxxx").packString("yyy-yyyy");
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[]{98, 105, 110, 97, 114, 121, 100, 97, 116, 97});
        messagePacker.packBinaryHeader(byteBuffer.remaining());
        messagePacker.writePayload(byteBuffer);
    }

    public static void readAndWriteFile() throws IOException {
        File file = File.createTempFile("target/tmp", ".txt");
        file.deleteOnExit();
        MessagePacker messagePacker = MessagePack.newDefaultPacker(new FileOutputStream(file));
        messagePacker.packInt(1);
        messagePacker.packString("Hello Message Pack!");
        messagePacker.packArrayHeader(2).packFloat(0.1f).packDouble(0.342);
        messagePacker.close();
        MessageUnpacker messageUnpacker = MessagePack.newDefaultUnpacker(new FileInputStream(file));
        block10: while (messageUnpacker.hasNext()) {
            MessageFormat messageFormat = messageUnpacker.getNextFormat();
            ValueHolder valueHolder = new ValueHolder();
            messageFormat = messageUnpacker.unpackValue(valueHolder);
            switch (messageFormat.getValueType()) {
                case NIL: {
                    Value value = valueHolder.get();
                    value.isNil();
                    System.out.println("read nil");
                    break;
                }
                case BOOLEAN: {
                    boolean bl = valueHolder.get().asBoolean().toBoolean();
                    System.out.println("read boolean: " + bl);
                    break;
                }
                case INTEGER: {
                    IntegerHolder integerHolder = valueHolder.getIntegerHolder();
                    if (integerHolder.isValidInt()) {
                        int n = integerHolder.asInt();
                        System.out.println("read int: " + n);
                        break;
                    }
                    long l = integerHolder.asLong();
                    System.out.println("read long: " + l);
                    break;
                }
                case FLOAT: {
                    FloatHolder floatHolder = valueHolder.getFloatHolder();
                    float f = floatHolder.toFloat();
                    double d = floatHolder.toDouble();
                    System.out.println("read float: " + d);
                    break;
                }
                case STRING: {
                    String string = valueHolder.get().asString().toString();
                    System.out.println("read string: " + string);
                    break;
                }
                case BINARY: {
                    MessageBuffer messageBuffer = valueHolder.get().asBinary().toMessageBuffer();
                    System.out.println("read binary: " + messageBuffer.toHexString(0, messageBuffer.size()));
                    break;
                }
                case ARRAY: {
                    ArrayValue arrayValue = valueHolder.get().asArrayValue();
                    for (ValueRef valueRef : arrayValue) {
                        System.out.println("read array element: " + valueRef);
                    }
                    continue block10;
                }
                case EXTENDED: {
                    ExtendedValue extendedValue = valueHolder.get().asExtended();
                    int n = extendedValue.getExtType();
                    byte[] byArray = extendedValue.toByteArray();
                }
            }
        }
    }

    public static void configuration() throws IOException {
        MessagePack.Config config = new MessagePack.ConfigBuilder().onMalFormedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).packerBufferSize(16384).build();
        MessagePack messagePack = new MessagePack(config);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        MessagePacker messagePacker = messagePack.newPacker(byteArrayOutputStream);
        messagePacker.packInt(10);
        messagePacker.packBoolean(true);
        messagePacker.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        MessageUnpacker messageUnpacker = messagePack.newUnpacker(byArray);
        int n = messageUnpacker.unpackInt();
        boolean bl = messageUnpacker.unpackBoolean();
        messageUnpacker.close();
    }
}

