/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.msgpack.core;

import java.math.BigInteger;

public class NumberUtil {
    private static final BigInteger BI_BYTE_MIN = BigInteger.valueOf(-128L);
    private static final BigInteger BI_BYTE_MAX = BigInteger.valueOf(127L);
    private static final BigInteger BI_SHORT_MIN = BigInteger.valueOf(-32768L);
    private static final BigInteger BI_SHORT_MAX = BigInteger.valueOf(32767L);
    private static final BigInteger BI_INT_MIN = BigInteger.valueOf(Integer.MIN_VALUE);
    private static final BigInteger BI_INT_MAX = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger BI_LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger BI_LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);

    public static class LongUtil {
        public static boolean isValidByte(long l) {
            return -128L <= l && l <= 127L;
        }

        public static boolean isValidByte(BigInteger bigInteger) {
            return bigInteger.compareTo(BI_BYTE_MIN) >= 0 && bigInteger.compareTo(BI_BYTE_MAX) <= 0;
        }

        public static boolean isValidShort(long l) {
            return -32768L <= l && l <= 32767L;
        }

        public static boolean isValidShort(BigInteger bigInteger) {
            return bigInteger.compareTo(BI_SHORT_MIN) >= 0 && bigInteger.compareTo(BI_SHORT_MAX) <= 0;
        }

        public static boolean isValidInt(long l) {
            return Integer.MIN_VALUE <= l && l <= Integer.MAX_VALUE;
        }

        public static boolean isValidInt(BigInteger bigInteger) {
            return bigInteger.compareTo(BI_INT_MIN) >= 0 && bigInteger.compareTo(BI_INT_MAX) <= 0;
        }

        public static boolean isValidLong(BigInteger bigInteger) {
            return bigInteger.compareTo(BI_LONG_MIN) >= 0 && bigInteger.compareTo(BI_LONG_MAX) <= 0;
        }
    }
}

