/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.impl;

import java.math.BigInteger;
import java.util.concurrent.TimeUnit;

class TimeUtil {
    TimeUtil() {
    }

    static long nowMs() {
        return TimeUnit.MILLISECONDS.convert(System.nanoTime(), TimeUnit.NANOSECONDS);
    }

    static long deltaMs(long startMs, long endMs) {
        BigInteger startNs = BigInteger.valueOf(TimeUnit.NANOSECONDS.convert(startMs, TimeUnit.MILLISECONDS));
        BigInteger endNs = BigInteger.valueOf(TimeUnit.NANOSECONDS.convert(endMs, TimeUnit.MILLISECONDS));
        BigInteger deltaNs = endNs.subtract(startNs);
        if (deltaNs.signum() >= 0) {
            return TimeUnit.MILLISECONDS.convert(deltaNs.min(BigInteger.valueOf(Long.MAX_VALUE)).longValue(), TimeUnit.NANOSECONDS);
        }
        if ((deltaNs = deltaNs.negate()).compareTo(BigInteger.valueOf(0x3FFFFFFFFFFFFFFFL)) < 0) {
            return 0L;
        }
        BigInteger revDeltaNs = BigInteger.ONE.shiftLeft(64).subtract(deltaNs);
        return TimeUnit.MILLISECONDS.convert(revDeltaNs.min(BigInteger.valueOf(Long.MAX_VALUE)).longValue(), TimeUnit.NANOSECONDS);
    }
}

