/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.htrace.core.MilliSpan;
import org.apache.htrace.core.Span;
import org.apache.htrace.core.SpanId;
import org.apache.htrace.core.TimelineAnnotation;
import org.apache.htrace.msgpack.core.MessagePack;
import org.apache.htrace.msgpack.core.MessagePacker;
import org.apache.htrace.msgpack.core.MessageUnpacker;
import org.apache.htrace.msgpack.core.buffer.MessageBuffer;
import org.apache.htrace.msgpack.core.buffer.MessageBufferOutput;
import org.apache.htrace.shaded.commons.logging.Log;
import org.apache.htrace.shaded.commons.logging.LogFactory;

class PackedBuffer {
    private static final Log LOG = LogFactory.getLog(PackedBuffer.class);
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private static final byte[] NUM_SPANS = "NumSpans".getBytes(UTF8);
    private static final byte[] DEFAULT_PID = "DefaultPid".getBytes(UTF8);
    private static final byte[] A = "a".getBytes(UTF8);
    private static final byte[] B = "b".getBytes(UTF8);
    private static final byte[] E = "e".getBytes(UTF8);
    private static final byte[] D = "d".getBytes(UTF8);
    private static final byte[] R = "r".getBytes(UTF8);
    private static final byte[] P = "p".getBytes(UTF8);
    private static final byte[] N = "n".getBytes(UTF8);
    private static final byte[] T = "t".getBytes(UTF8);
    private static final byte[] M = "m".getBytes(UTF8);
    private static final int HRPC_MAGIC = 1129469000;
    static final int HRPC_REQ_FRAME_LENGTH = 20;
    static final int HRPC_RESP_FRAME_LENGTH = 20;
    static final int MAX_HRPC_ERROR_LENGTH = 0x400000;
    static final int MAX_HRPC_BODY_LENGTH = 0x4000000;
    private static final int SPAN_ID_BYTE_LENGTH = 16;
    static final MessagePack.Config MSGPACK_CONF = new MessagePack.ConfigBuilder().readBinaryAsString(false).readStringAsBinary(false).build();
    final ByteBuffer bb;
    final PackedBufferOutput out;
    final byte[] temp;
    final MessagePacker packer;

    PackedBuffer(ByteBuffer bb) {
        this.bb = bb;
        this.out = new PackedBufferOutput();
        this.temp = new byte[16];
        this.packer = new MessagePacker(this.out, MSGPACK_CONF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeReqFrame(ByteBuffer bb, int methodId, long seq, int length) throws IOException {
        int oldPos = bb.position();
        boolean success = false;
        try {
            bb.order(ByteOrder.LITTLE_ENDIAN);
            bb.putInt(1129469000);
            bb.putInt(methodId);
            bb.putLong(seq);
            bb.putInt(length);
            success = true;
        }
        finally {
            if (!success) {
                bb.position(oldPos);
            }
        }
    }

    private static void longToBigEndian(byte[] b, int pos, long val) {
        b[pos + 0] = (byte)(val >> 56 & 0xFFL);
        b[pos + 1] = (byte)(val >> 48 & 0xFFL);
        b[pos + 2] = (byte)(val >> 40 & 0xFFL);
        b[pos + 3] = (byte)(val >> 32 & 0xFFL);
        b[pos + 4] = (byte)(val >> 24 & 0xFFL);
        b[pos + 5] = (byte)(val >> 16 & 0xFFL);
        b[pos + 6] = (byte)(val >> 8 & 0xFFL);
        b[pos + 7] = (byte)(val >> 0 & 0xFFL);
    }

    private void writeSpanId(SpanId spanId) throws IOException {
        PackedBuffer.longToBigEndian(this.temp, 0, spanId.getHigh());
        PackedBuffer.longToBigEndian(this.temp, 8, spanId.getLow());
        this.packer.packBinaryHeader(16);
        this.packer.writePayload(this.temp, 0, 16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeSpan(Span span) throws IOException {
        boolean success = false;
        int oldPos = this.bb.position();
        try {
            int mapSize = 0;
            if (span.getSpanId().isValid()) {
                ++mapSize;
            }
            if (span.getStartTimeMillis() != 0L) {
                ++mapSize;
            }
            if (span.getStopTimeMillis() != 0L) {
                ++mapSize;
            }
            if (!span.getDescription().isEmpty()) {
                ++mapSize;
            }
            if (!span.getTracerId().isEmpty()) {
                ++mapSize;
            }
            if (span.getParents().length > 0) {
                ++mapSize;
            }
            if (!span.getKVAnnotations().isEmpty()) {
                ++mapSize;
            }
            if (!span.getTimelineAnnotations().isEmpty()) {
                ++mapSize;
            }
            this.packer.packMapHeader(mapSize);
            if (span.getSpanId().isValid()) {
                this.packer.packRawStringHeader(1);
                this.packer.writePayload(A);
                this.writeSpanId(span.getSpanId());
            }
            if (span.getStartTimeMillis() != 0L) {
                this.packer.packRawStringHeader(1);
                this.packer.writePayload(B);
                this.packer.packLong(span.getStartTimeMillis());
            }
            if (span.getStopTimeMillis() != 0L) {
                this.packer.packRawStringHeader(1);
                this.packer.writePayload(E);
                this.packer.packLong(span.getStopTimeMillis());
            }
            if (!span.getDescription().isEmpty()) {
                this.packer.packRawStringHeader(1);
                this.packer.writePayload(D);
                this.packer.packString(span.getDescription());
            }
            if (!span.getTracerId().isEmpty()) {
                this.packer.packRawStringHeader(1);
                this.packer.writePayload(R);
                this.packer.packString(span.getTracerId());
            }
            if (span.getParents().length > 0) {
                this.packer.packRawStringHeader(1);
                this.packer.writePayload(P);
                this.packer.packArrayHeader(span.getParents().length);
                for (int i = 0; i < span.getParents().length; ++i) {
                    this.writeSpanId(span.getParents()[i]);
                }
            }
            if (!span.getKVAnnotations().isEmpty()) {
                this.packer.packRawStringHeader(1);
                this.packer.writePayload(N);
                Map map = span.getKVAnnotations();
                this.packer.packMapHeader(map.size());
                for (Map.Entry entry : map.entrySet()) {
                    this.packer.packString((String)entry.getKey());
                    this.packer.packString((String)entry.getValue());
                }
            }
            if (!span.getTimelineAnnotations().isEmpty()) {
                this.packer.packRawStringHeader(1);
                this.packer.writePayload(T);
                List list = span.getTimelineAnnotations();
                this.packer.packArrayHeader(list.size());
                for (TimelineAnnotation annotation : list) {
                    this.packer.packMapHeader(2);
                    this.packer.packRawStringHeader(1);
                    this.packer.writePayload(T);
                    this.packer.packLong(annotation.getTime());
                    this.packer.packRawStringHeader(1);
                    this.packer.writePayload(M);
                    this.packer.packString(annotation.getMessage());
                }
            }
            this.packer.flush();
            success = true;
        }
        finally {
            if (!success) {
                this.bb.position(oldPos);
            }
        }
    }

    static SpanId readSpanId(MessageUnpacker unpacker) throws IOException {
        int alen = unpacker.unpackBinaryHeader();
        if (alen != 16) {
            throw new IOException("Invalid length given for spanID array.  Expected 16; got " + alen);
        }
        byte[] payload = new byte[16];
        unpacker.readPayload(payload);
        return new SpanId(((long)payload[7] & 0xFFL) << 0 | ((long)payload[6] & 0xFFL) << 8 | ((long)payload[5] & 0xFFL) << 16 | ((long)payload[4] & 0xFFL) << 24 | ((long)payload[3] & 0xFFL) << 32 | ((long)payload[2] & 0xFFL) << 40 | ((long)payload[1] & 0xFFL) << 48 | ((long)payload[0] & 0xFFL) << 56, ((long)payload[15] & 0xFFL) << 0 | ((long)payload[14] & 0xFFL) << 8 | ((long)payload[13] & 0xFFL) << 16 | ((long)payload[12] & 0xFFL) << 24 | ((long)payload[11] & 0xFFL) << 32 | ((long)payload[10] & 0xFFL) << 40 | ((long)payload[9] & 0xFFL) << 48 | ((long)payload[8] & 0xFFL) << 56);
    }

    static Span readSpan(MessageUnpacker unpacker) throws IOException {
        int numEntries = unpacker.unpackMapHeader();
        MilliSpan.Builder builder = new MilliSpan.Builder();
        block14: while (--numEntries >= 0) {
            String key = unpacker.unpackString();
            if (key.length() != 1) {
                throw new IOException("Unknown key " + key);
            }
            switch (key.charAt(0)) {
                case 'a': {
                    builder.spanId(PackedBuffer.readSpanId(unpacker));
                    continue block14;
                }
                case 'b': {
                    builder.begin(unpacker.unpackLong());
                    continue block14;
                }
                case 'e': {
                    builder.end(unpacker.unpackLong());
                    continue block14;
                }
                case 'd': {
                    builder.description(unpacker.unpackString());
                    continue block14;
                }
                case 'r': {
                    builder.tracerId(unpacker.unpackString());
                    continue block14;
                }
                case 'p': {
                    int numParents = unpacker.unpackArrayHeader();
                    SpanId[] parents = new SpanId[numParents];
                    for (int i = 0; i < numParents; ++i) {
                        parents[i] = PackedBuffer.readSpanId(unpacker);
                    }
                    builder.parents(parents);
                    continue block14;
                }
                case 'n': {
                    int mapEntries = unpacker.unpackMapHeader();
                    HashMap<String, String> entries = new HashMap<String, String>(mapEntries);
                    for (int i = 0; i < mapEntries; ++i) {
                        String k = unpacker.unpackString();
                        String v = unpacker.unpackString();
                        entries.put(k, v);
                    }
                    builder.traceInfo(entries);
                    continue block14;
                }
                case 't': {
                    int listEntries = unpacker.unpackArrayHeader();
                    ArrayList<TimelineAnnotation> list = new ArrayList<TimelineAnnotation>(listEntries);
                    for (int i = 0; i < listEntries; ++i) {
                        int timelineObjectSize = unpacker.unpackMapHeader();
                        long time = 0L;
                        String msg = "";
                        block18: for (int j = 0; j < timelineObjectSize; ++j) {
                            String tlKey = unpacker.unpackString();
                            if (tlKey.length() != 1) {
                                throw new IOException("Unknown timeline map key " + tlKey);
                            }
                            switch (tlKey.charAt(0)) {
                                case 't': {
                                    time = unpacker.unpackLong();
                                    continue block18;
                                }
                                case 'm': {
                                    msg = unpacker.unpackString();
                                    continue block18;
                                }
                                default: {
                                    throw new IOException("Unknown timeline map key " + tlKey);
                                }
                            }
                        }
                        list.add(new TimelineAnnotation(time, msg));
                    }
                    builder.timeline(list);
                    continue block14;
                }
            }
            throw new IOException("Unknown key " + key);
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void beginWriteSpansRequest(String defaultPid, int numSpans) throws IOException {
        boolean success = false;
        int oldPos = this.bb.position();
        try {
            int mapSize = 1;
            if (defaultPid != null) {
                ++mapSize;
            }
            this.packer.packMapHeader(mapSize);
            if (defaultPid != null) {
                this.packer.packRawStringHeader(DEFAULT_PID.length);
                this.packer.writePayload(DEFAULT_PID);
                this.packer.packString(defaultPid);
            }
            this.packer.packRawStringHeader(NUM_SPANS.length);
            this.packer.writePayload(NUM_SPANS);
            this.packer.packInt(numSpans);
            this.packer.flush();
            success = true;
        }
        finally {
            if (!success) {
                this.bb.position(oldPos);
            }
        }
    }

    ByteBuffer getBuffer() {
        return this.bb;
    }

    void reset() throws IOException {
        this.packer.reset(this.out);
    }

    void close() {
        try {
            this.packer.close();
        }
        catch (IOException e) {
            LOG.error("Error closing MessagePacker", e);
        }
    }

    public String toHexString() {
        String prefix = "";
        StringBuilder bld = new StringBuilder();
        ByteBuffer b = this.bb.duplicate();
        b.flip();
        while (b.hasRemaining()) {
            bld.append(String.format("%s%02x", prefix, b.get()));
            prefix = " ";
        }
        return bld.toString();
    }

    private class PackedBufferOutput
    implements MessageBufferOutput {
        private MessageBuffer savedBuffer;

        PackedBufferOutput() {
        }

        @Override
        public MessageBuffer next(int bufferSize) throws IOException {
            if (this.savedBuffer == null || this.savedBuffer.size() != bufferSize) {
                this.savedBuffer = MessageBuffer.newBuffer(bufferSize);
            }
            MessageBuffer buffer = this.savedBuffer;
            this.savedBuffer = null;
            return buffer;
        }

        @Override
        public void flush(MessageBuffer buffer) throws IOException {
            ByteBuffer b = buffer.toByteBuffer();
            PackedBuffer.this.bb.put(b);
            this.savedBuffer = buffer;
        }

        @Override
        public void close() throws IOException {
        }
    }
}

