/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.PosixFilePermission;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.htrace.core.HTraceConfiguration;
import org.apache.htrace.core.Span;
import org.apache.htrace.core.SpanReceiver;
import org.apache.htrace.impl.BufferManager;
import org.apache.htrace.impl.Conf;
import org.apache.htrace.impl.PackedBufferManager;
import org.apache.htrace.impl.RateLimitedLogger;
import org.apache.htrace.impl.RestBufferManager;
import org.apache.htrace.impl.TimeUtil;
import org.apache.htrace.shaded.commons.logging.Log;
import org.apache.htrace.shaded.commons.logging.LogFactory;

public class HTracedSpanReceiver
extends SpanReceiver {
    private static final Log LOG = LogFactory.getLog(HTracedSpanReceiver.class);
    private static final int MAX_CLOSING_WAIT_MS = 120000;
    private final FaultInjector faultInjector;
    private final Conf conf;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition wakePostSpansThread = this.lock.newCondition();
    private final BufferManager[] bufferManager = new BufferManager[2];
    private final RateLimitedLogger flushErrorLog;
    private final RateLimitedLogger spanDropLog;
    private final PostSpansThread thread;
    private boolean shutdown = false;
    private int activeBuf = 0;
    private int flushingBuf = -1;
    private long lastBufferClearedTimeMs = 0L;
    private long unbufferableSpans = 0L;
    private static final SimpleDateFormat ISO_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private static final Set<PosixFilePermission> DROPPED_SPANS_FILE_PERMS;

    public HTracedSpanReceiver(HTraceConfiguration c) throws Exception {
        this(c, FaultInjector.NO_OP);
    }

    HTracedSpanReceiver(HTraceConfiguration c, FaultInjector faultInjector) throws Exception {
        this.faultInjector = faultInjector;
        this.conf = new Conf(c);
        if (this.conf.packed) {
            for (int i = 0; i < this.bufferManager.length; ++i) {
                this.bufferManager[i] = new PackedBufferManager(this.conf);
            }
        } else {
            for (int i = 0; i < this.bufferManager.length; ++i) {
                this.bufferManager[i] = new RestBufferManager(this.conf);
            }
        }
        this.flushErrorLog = new RateLimitedLogger(LOG, this.conf.errorLogPeriodMs);
        this.spanDropLog = new RateLimitedLogger(LOG, this.conf.errorLogPeriodMs);
        this.thread = new PostSpansThread();
        LOG.debug("Created new HTracedSpanReceiver with " + this.conf.toString());
    }

    /*
     * Exception decompiling
     */
    public void receiveSpan(Span span) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.lock.lock();
        try {
            this.shutdown = true;
            this.wakePostSpansThread.signal();
        }
        finally {
            this.lock.unlock();
        }
        try {
            this.thread.join(120000L);
        }
        catch (InterruptedException e) {
            LOG.error("HTracedSpanReceiver#close was interrupted", e);
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void appendToDroppedSpansLog(String text) throws IOException {
        if (this.conf.droppedSpansLogPath.isEmpty() || this.conf.droppedSpansLogMaxSize == 0L) {
            return;
        }
        FileLock lock = null;
        String msg = ISO_DATE_FORMAT.format(new Date()) + ": " + text;
        ByteBuffer bb = ByteBuffer.wrap(msg.getBytes(StandardCharsets.UTF_8));
        Class<HTracedSpanReceiver> clazz = HTracedSpanReceiver.class;
        synchronized (HTracedSpanReceiver.class) {
            FileChannel channel = FileChannel.open(Paths.get(this.conf.droppedSpansLogPath, new String[0]), StandardOpenOption.APPEND, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
            try {
                lock = channel.lock();
                long size = channel.size();
                if (size > this.conf.droppedSpansLogMaxSize) {
                    throw new IOException("Dropped spans log " + this.conf.droppedSpansLogPath + " is already " + size + " bytes; will not add to it.");
                }
                if (size == 0L && DROPPED_SPANS_FILE_PERMS != null) {
                    Files.setPosixFilePermissions(Paths.get(this.conf.droppedSpansLogPath, new String[0]), DROPPED_SPANS_FILE_PERMS);
                }
                channel.write(bb);
            }
            finally {
                try {
                    if (lock != null) {
                        lock.release();
                    }
                }
                finally {
                    channel.close();
                }
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    static {
        ISO_DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
        if (FileSystems.getDefault().supportedFileAttributeViews().contains("posix")) {
            DROPPED_SPANS_FILE_PERMS = new HashSet<PosixFilePermission>();
            DROPPED_SPANS_FILE_PERMS.add(PosixFilePermission.OWNER_READ);
            DROPPED_SPANS_FILE_PERMS.add(PosixFilePermission.OWNER_WRITE);
            DROPPED_SPANS_FILE_PERMS.add(PosixFilePermission.GROUP_READ);
            DROPPED_SPANS_FILE_PERMS.add(PosixFilePermission.GROUP_WRITE);
            DROPPED_SPANS_FILE_PERMS.add(PosixFilePermission.OTHERS_READ);
            DROPPED_SPANS_FILE_PERMS.add(PosixFilePermission.OTHERS_WRITE);
        } else {
            DROPPED_SPANS_FILE_PERMS = null;
        }
    }

    private class PostSpansThread
    extends Thread {
        PostSpansThread() {
            this.setDaemon(true);
            this.setName("PostSpans");
            this.start();
        }

        private boolean shouldWaitForCond(long timeSinceLastClearedMs) {
            if (HTracedSpanReceiver.this.shutdown) {
                LOG.trace("Should not wait for cond because we're shutting down.");
                return false;
            }
            int contentLength = HTracedSpanReceiver.this.bufferManager[HTracedSpanReceiver.this.activeBuf].contentLength();
            if (contentLength == 0) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Should wait for cond because we have no data buffered in bufferManager " + HTracedSpanReceiver.this.activeBuf);
                }
                HTracedSpanReceiver.this.lastBufferClearedTimeMs = TimeUtil.nowMs();
                return true;
            }
            if (contentLength >= ((HTracedSpanReceiver)HTracedSpanReceiver.this).conf.triggerSize) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Should not wait for cond because we have more than " + ((HTracedSpanReceiver)HTracedSpanReceiver.this).conf.triggerSize + " bytes buffered in bufferManager " + HTracedSpanReceiver.this.activeBuf);
                }
                return false;
            }
            if (timeSinceLastClearedMs > (long)((HTracedSpanReceiver)HTracedSpanReceiver.this).conf.maxFlushIntervalMs) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Should not wait for cond because it has been " + timeSinceLastClearedMs + " ms since our last flush, and we " + "are overdue for another because maxFlushIntervalMs is " + ((HTracedSpanReceiver)HTracedSpanReceiver.this).conf.maxFlushIntervalMs);
                }
                return false;
            }
            LOG.trace("Should wait for cond.");
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            try {
                HTracedSpanReceiver.this.faultInjector.handleThreadStart();
                LOG.debug("Starting HTracedSpanReceiver thread for " + ((HTracedSpanReceiver)HTracedSpanReceiver.this).conf.endpointStr);
                BufferManager flushBufManager = null;
                while (true) {
                    block17: {
                        long timeSinceLastClearedMs;
                        HTracedSpanReceiver.this.lock.lock();
                        HTracedSpanReceiver.this.flushingBuf = -1;
                        while (this.shouldWaitForCond(timeSinceLastClearedMs = TimeUtil.deltaMs(HTracedSpanReceiver.this.lastBufferClearedTimeMs, TimeUtil.nowMs()))) {
                            long waitMs = (long)((HTracedSpanReceiver)HTracedSpanReceiver.this).conf.maxFlushIntervalMs - Math.min((long)((HTracedSpanReceiver)HTracedSpanReceiver.this).conf.maxFlushIntervalMs, TimeUtil.deltaMs(TimeUtil.nowMs(), HTracedSpanReceiver.this.lastBufferClearedTimeMs));
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("Waiting on wakePostSpansThread for " + waitMs + " ms.");
                            }
                            try {
                                HTracedSpanReceiver.this.wakePostSpansThread.await(waitMs, TimeUnit.MILLISECONDS);
                            }
                            catch (InterruptedException e) {
                                LOG.info("HTraceSpanReceiver thread was interrupted.", e);
                                throw e;
                            }
                        }
                        if (!HTracedSpanReceiver.this.shutdown || HTracedSpanReceiver.this.bufferManager[HTracedSpanReceiver.this.activeBuf].contentLength() != 0) break block17;
                        LOG.debug("PostSpansThread shutting down.");
                        HTracedSpanReceiver.this.lock.unlock();
                        return;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    try {
                        HTracedSpanReceiver.this.flushingBuf = HTracedSpanReceiver.this.activeBuf;
                        flushBufManager = HTracedSpanReceiver.this.bufferManager[HTracedSpanReceiver.this.flushingBuf];
                        HTracedSpanReceiver.this.activeBuf = HTracedSpanReceiver.this.activeBuf == 1 ? 0 : 1;
                    }
                    finally {
                        HTracedSpanReceiver.this.lock.unlock();
                    }
                    this.doFlush(flushBufManager);
                    flushBufManager.clear();
                    HTracedSpanReceiver.this.lastBufferClearedTimeMs = TimeUtil.nowMs();
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace("setting lastBufferClearedTimeMs to " + HTracedSpanReceiver.this.lastBufferClearedTimeMs);
                    continue;
                    break;
                }
                catch (Throwable e) {
                    LOG.error("PostSpansThread exiting on unexpected exception", e);
                    for (int i = 0; i < HTracedSpanReceiver.this.bufferManager.length; ++i) {
                        HTracedSpanReceiver.this.bufferManager[i].close();
                    }
                }
            }
            finally {
                for (int i = 0; i < HTracedSpanReceiver.this.bufferManager.length; ++i) {
                    HTracedSpanReceiver.this.bufferManager[i].close();
                }
            }
        }

        private void doFlush(BufferManager flushBufManager) throws InterruptedException {
            try {
                flushBufManager.prepare();
            }
            catch (IOException e) {
                LOG.error("Failed to prepare buffer containing " + flushBufManager.getNumberOfSpans() + " spans for " + "sending to " + ((HTracedSpanReceiver)HTracedSpanReceiver.this).conf.endpointStr + " Discarding " + "all spans.", e);
                return;
            }
            int flushTries = 0;
            if (HTracedSpanReceiver.this.unbufferableSpans > 0L) {
                try {
                    HTracedSpanReceiver.this.appendToDroppedSpansLog("Dropped " + HTracedSpanReceiver.this.unbufferableSpans + " spans because of lack of local buffer space.\n");
                }
                catch (IOException e) {
                    // empty catch block
                }
                HTracedSpanReceiver.this.unbufferableSpans = 0L;
            }
            while (true) {
                Exception exc;
                try {
                    HTracedSpanReceiver.this.faultInjector.handleFlush();
                    flushBufManager.flush();
                    exc = null;
                }
                catch (RuntimeException e) {
                    exc = e;
                }
                catch (Exception e) {
                    exc = e;
                }
                if (exc == null) {
                    return;
                }
                int numSpans = flushBufManager.getNumberOfSpans();
                HTracedSpanReceiver.this.flushErrorLog.error("Failed to flush " + numSpans + " htrace " + "spans to " + ((HTracedSpanReceiver)HTracedSpanReceiver.this).conf.endpointStr + " on try " + (flushTries + 1), exc);
                if (flushTries >= ((HTracedSpanReceiver)HTracedSpanReceiver.this).conf.flushRetryDelays.length) {
                    StringBuilder bld = new StringBuilder();
                    bld.append("Failed to flush ").append(numSpans).append(" spans to htraced at").append(((HTracedSpanReceiver)HTracedSpanReceiver.this).conf.endpointStr).append(" after ").append(flushTries).append(" tries: ").append(exc.getMessage()).append("\n");
                    try {
                        HTracedSpanReceiver.this.appendToDroppedSpansLog(bld.toString());
                    }
                    catch (IOException e) {
                        bld.append(".  Failed to write to dropped spans log: ").append(e.getMessage());
                    }
                    HTracedSpanReceiver.this.spanDropLog.error(bld.toString());
                    return;
                }
                int delayMs = ((HTracedSpanReceiver)HTracedSpanReceiver.this).conf.flushRetryDelays[flushTries];
                Thread.sleep(delayMs);
                ++flushTries;
            }
        }
    }

    static class FaultInjector {
        static FaultInjector NO_OP = new FaultInjector();

        FaultInjector() {
        }

        public void handleContentLengthTrigger(int len) {
        }

        public void handleThreadStart() throws Exception {
        }

        public void handleFlush() throws IOException {
        }
    }
}

