/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.jetty.client;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.htrace.jetty.client.ContentDecoder;
import org.apache.htrace.jetty.client.HttpChannel;
import org.apache.htrace.jetty.client.HttpClient;
import org.apache.htrace.jetty.client.HttpConversation;
import org.apache.htrace.jetty.client.HttpDestination;
import org.apache.htrace.jetty.client.HttpExchange;
import org.apache.htrace.jetty.client.HttpResponse;
import org.apache.htrace.jetty.client.ProtocolHandler;
import org.apache.htrace.jetty.client.ResponseNotifier;
import org.apache.htrace.jetty.client.api.Response;
import org.apache.htrace.jetty.client.api.Result;
import org.apache.htrace.jetty.http.HttpField;
import org.apache.htrace.jetty.http.HttpHeader;
import org.apache.htrace.jetty.util.BufferUtil;
import org.apache.htrace.jetty.util.Callback;
import org.apache.htrace.jetty.util.log.Log;
import org.apache.htrace.jetty.util.log.Logger;

public abstract class HttpReceiver {
    protected static final Logger LOG = Log.getLogger(HttpReceiver.class);
    private final AtomicReference<ResponseState> responseState = new AtomicReference<ResponseState>(ResponseState.IDLE);
    private final HttpChannel channel;
    private ContentDecoder decoder;
    private Throwable failure;

    protected HttpReceiver(HttpChannel channel) {
        this.channel = channel;
    }

    protected HttpChannel getHttpChannel() {
        return this.channel;
    }

    protected HttpExchange getHttpExchange() {
        return this.channel.getHttpExchange();
    }

    protected HttpDestination getHttpDestination() {
        return this.channel.getHttpDestination();
    }

    protected boolean responseBegin(HttpExchange exchange) {
        if (!this.updateResponseState(ResponseState.IDLE, ResponseState.TRANSIENT)) {
            return false;
        }
        HttpConversation conversation = exchange.getConversation();
        HttpResponse response = exchange.getResponse();
        HttpDestination destination = this.getHttpDestination();
        HttpClient client = destination.getHttpClient();
        ProtocolHandler protocolHandler = client.findProtocolHandler(exchange.getRequest(), response);
        Response.Listener handlerListener = null;
        if (protocolHandler != null) {
            handlerListener = protocolHandler.getResponseListener();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found protocol handler {}", protocolHandler);
            }
        }
        exchange.getConversation().updateResponseListeners(handlerListener);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response begin {}", response);
        }
        ResponseNotifier notifier = destination.getResponseNotifier();
        notifier.notifyBegin(conversation.getResponseListeners(), (Response)response);
        if (!this.updateResponseState(ResponseState.TRANSIENT, ResponseState.BEGIN)) {
            this.terminateResponse(exchange, this.failure);
        }
        return true;
    }

    protected boolean responseHeader(HttpExchange exchange, HttpField field) {
        block6: while (true) {
            ResponseState current = this.responseState.get();
            switch (current) {
                case BEGIN: 
                case HEADER: {
                    if (!this.updateResponseState(current, ResponseState.TRANSIENT)) continue block6;
                    break block6;
                }
                default: {
                    return false;
                }
            }
            break;
        }
        HttpResponse response = exchange.getResponse();
        ResponseNotifier notifier = this.getHttpDestination().getResponseNotifier();
        boolean process = notifier.notifyHeader(exchange.getConversation().getResponseListeners(), (Response)response, field);
        if (process) {
            response.getHeaders().add(field);
            HttpHeader fieldHeader = field.getHeader();
            if (fieldHeader != null) {
                switch (fieldHeader) {
                    case SET_COOKIE: 
                    case SET_COOKIE2: {
                        this.storeCookie(exchange.getRequest().getURI(), field);
                        break;
                    }
                }
            }
        }
        if (!this.updateResponseState(ResponseState.TRANSIENT, ResponseState.HEADER)) {
            this.terminateResponse(exchange, this.failure);
        }
        return true;
    }

    protected void storeCookie(URI uri, HttpField field) {
        block3: {
            try {
                String value = field.getValue();
                if (value != null) {
                    HashMap<String, List<String>> header = new HashMap<String, List<String>>(1);
                    header.put(field.getHeader().asString(), Collections.singletonList(value));
                    this.getHttpDestination().getHttpClient().getCookieManager().put(uri, header);
                }
            }
            catch (IOException x) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug(x);
            }
        }
    }

    protected boolean responseHeaders(HttpExchange exchange) {
        block3: while (true) {
            ResponseState current = this.responseState.get();
            switch (current) {
                case BEGIN: 
                case HEADER: {
                    if (!this.updateResponseState(current, ResponseState.TRANSIENT)) continue block3;
                    break block3;
                }
                default: {
                    return false;
                }
            }
            break;
        }
        HttpResponse response = exchange.getResponse();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response headers {}{}{}", response, System.lineSeparator(), response.getHeaders().toString().trim());
        }
        ResponseNotifier notifier = this.getHttpDestination().getResponseNotifier();
        notifier.notifyHeaders(exchange.getConversation().getResponseListeners(), (Response)response);
        Enumeration<String> contentEncodings = response.getHeaders().getValues(HttpHeader.CONTENT_ENCODING.asString(), ",");
        if (contentEncodings != null) {
            block4: for (ContentDecoder.Factory factory : this.getHttpDestination().getHttpClient().getContentDecoderFactories()) {
                while (contentEncodings.hasMoreElements()) {
                    if (!factory.getEncoding().equalsIgnoreCase(contentEncodings.nextElement())) continue;
                    this.decoder = factory.newContentDecoder();
                    continue block4;
                }
            }
        }
        if (!this.updateResponseState(ResponseState.TRANSIENT, ResponseState.HEADERS)) {
            this.terminateResponse(exchange, this.failure);
        }
        return true;
    }

    protected boolean responseContent(HttpExchange exchange, ByteBuffer buffer, final Callback callback) {
        block3: while (true) {
            ResponseState current = this.responseState.get();
            switch (current) {
                case HEADERS: 
                case CONTENT: {
                    if (!this.updateResponseState(current, ResponseState.TRANSIENT)) continue block3;
                    break block3;
                }
                default: {
                    return false;
                }
            }
            break;
        }
        HttpResponse response = exchange.getResponse();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response content {}{}{}", response, System.lineSeparator(), BufferUtil.toDetailString(buffer));
        }
        ResponseNotifier notifier = this.getHttpDestination().getResponseNotifier();
        List<Response.ResponseListener> listeners = exchange.getConversation().getResponseListeners();
        ContentDecoder decoder = this.decoder;
        if (decoder == null) {
            notifier.notifyContent(listeners, (Response)response, buffer, callback);
        } else {
            ArrayList<ByteBuffer> decodeds = new ArrayList<ByteBuffer>(2);
            while (buffer.hasRemaining()) {
                ByteBuffer decoded = decoder.decode(buffer);
                if (!decoded.hasRemaining()) continue;
                decodeds.add(decoded);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Response content decoded ({}) {}{}{}", decoder, response, System.lineSeparator(), BufferUtil.toDetailString(decoded));
            }
            if (decodeds.isEmpty()) {
                callback.succeeded();
            } else {
                Callback.Adapter partial = new Callback.Adapter(){

                    @Override
                    public void failed(Throwable x) {
                        callback.failed(x);
                    }
                };
                int size = decodeds.size();
                for (int i = 1; i <= size; ++i) {
                    notifier.notifyContent(listeners, (Response)response, (ByteBuffer)decodeds.get(i - 1), i < size ? partial : callback);
                }
            }
        }
        if (!this.updateResponseState(ResponseState.TRANSIENT, ResponseState.CONTENT)) {
            this.terminateResponse(exchange, this.failure);
        }
        return true;
    }

    protected boolean responseSuccess(HttpExchange exchange) {
        boolean completed = exchange.responseComplete();
        if (!completed) {
            return false;
        }
        this.responseState.set(ResponseState.IDLE);
        this.reset();
        Result result = exchange.terminateResponse(null);
        HttpResponse response = exchange.getResponse();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response success {}", response);
        }
        List<Response.ResponseListener> listeners = exchange.getConversation().getResponseListeners();
        ResponseNotifier notifier = this.getHttpDestination().getResponseNotifier();
        notifier.notifySuccess(listeners, (Response)response);
        this.terminateResponse(exchange, result);
        return true;
    }

    protected boolean responseFailure(Throwable failure) {
        ResponseState current;
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return false;
        }
        boolean completed = exchange.responseComplete();
        if (!completed) {
            return false;
        }
        this.failure = failure;
        while (!this.updateResponseState(current = this.responseState.get(), ResponseState.FAILURE)) {
        }
        boolean fail = current != ResponseState.TRANSIENT;
        this.dispose();
        Result result = exchange.terminateResponse(failure);
        HttpResponse response = exchange.getResponse();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response failure {} {}", response, failure);
        }
        List<Response.ResponseListener> listeners = exchange.getConversation().getResponseListeners();
        ResponseNotifier notifier = this.getHttpDestination().getResponseNotifier();
        notifier.notifyFailure(listeners, (Response)response, failure);
        if (fail) {
            this.terminateResponse(exchange, result);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Concurrent failure: response termination skipped, performed by helpers", new Object[0]);
        }
        return true;
    }

    private void terminateResponse(HttpExchange exchange, Throwable failure) {
        Result result = exchange.terminateResponse(failure);
        this.terminateResponse(exchange, result);
    }

    private void terminateResponse(HttpExchange exchange, Result result) {
        HttpResponse response = exchange.getResponse();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response complete {}", response);
        }
        if (result != null) {
            boolean ordered = this.getHttpDestination().getHttpClient().isStrictEventOrdering();
            if (!ordered) {
                this.channel.exchangeTerminated(result);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Request/Response {} {}", this.failure == null ? "succeeded" : "failed", response);
            }
            List<Response.ResponseListener> listeners = exchange.getConversation().getResponseListeners();
            ResponseNotifier notifier = this.getHttpDestination().getResponseNotifier();
            notifier.notifyComplete(listeners, result);
            if (ordered) {
                this.channel.exchangeTerminated(result);
            }
        }
    }

    protected void reset() {
        this.decoder = null;
    }

    protected void dispose() {
        this.decoder = null;
    }

    public boolean abort(Throwable cause) {
        return this.responseFailure(cause);
    }

    private boolean updateResponseState(ResponseState from, ResponseState to) {
        boolean updated = this.responseState.compareAndSet(from, to);
        if (!updated && LOG.isDebugEnabled()) {
            LOG.debug("State update failed: {} -> {}: {}", new Object[]{from, to, this.responseState.get()});
        }
        return updated;
    }

    private static enum ResponseState {
        TRANSIENT,
        IDLE,
        BEGIN,
        HEADER,
        HEADERS,
        CONTENT,
        FAILURE;

    }
}

