/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.viewer;

import java.net.InetSocketAddress;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.htrace.shaded.commons.logging.Log;
import org.apache.htrace.shaded.commons.logging.LogFactory;
import org.apache.htrace.shaded.org.eclipse.jetty.server.Server;
import org.apache.htrace.shaded.org.eclipse.jetty.servlet.DefaultServlet;
import org.apache.htrace.shaded.org.eclipse.jetty.servlet.ServletContextHandler;
import org.apache.htrace.shaded.org.eclipse.jetty.servlet.ServletHolder;
import org.apache.htrace.viewer.HBaseSpanViewerSpansServlet;
import org.apache.htrace.viewer.HBaseSpanViewerTracesServlet;

public class HBaseSpanViewerServer
implements Tool {
    private static final Log LOG = LogFactory.getLog(HBaseSpanViewerServer.class);
    public static final String HTRACE_VIEWER_HTTP_ADDRESS_KEY = "htrace.viewer.http.address";
    public static final String HTRACE_VIEWER_HTTP_ADDRESS_DEFAULT = "0.0.0.0:16900";
    private Configuration conf;
    private Server server;

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void stop() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public int run(String[] args) throws Exception {
        URI uri = new URI("http://" + this.conf.get(HTRACE_VIEWER_HTTP_ADDRESS_KEY, HTRACE_VIEWER_HTTP_ADDRESS_DEFAULT));
        InetSocketAddress addr = new InetSocketAddress(uri.getHost(), uri.getPort());
        this.server = new Server(addr);
        ServletContextHandler root = new ServletContextHandler(this.server, "/", 1);
        this.server.setHandler(root);
        String resourceBase = this.server.getClass().getClassLoader().getResource("webapps/htrace").toExternalForm();
        root.setResourceBase(resourceBase);
        root.setWelcomeFiles(new String[]{"index.html"});
        root.addServlet(new ServletHolder(new DefaultServlet()), "/");
        root.addServlet(new ServletHolder(new HBaseSpanViewerTracesServlet(this.conf)), "/gettraces");
        root.addServlet(new ServletHolder(new HBaseSpanViewerSpansServlet(this.conf)), "/getspans/*");
        this.server.start();
        this.server.join();
        return 0;
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Configuration)HBaseConfiguration.create(), (Tool)new HBaseSpanViewerServer(), (String[])args);
    }
}

