/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesqueesque.common.requests;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafkaesqueesque.common.TopicPartition;
import org.apache.kafkaesqueesque.common.protocol.ApiKeys;
import org.apache.kafkaesqueesque.common.protocol.CommonFields;
import org.apache.kafkaesqueesque.common.protocol.Errors;
import org.apache.kafkaesqueesque.common.protocol.types.ArrayOf;
import org.apache.kafkaesqueesque.common.protocol.types.Field;
import org.apache.kafkaesqueesque.common.protocol.types.Schema;
import org.apache.kafkaesqueesque.common.protocol.types.Struct;
import org.apache.kafkaesqueesque.common.protocol.types.Type;
import org.apache.kafkaesqueesque.common.requests.AbstractResponse;
import org.apache.kafkaesqueesque.common.utils.CollectionUtils;

public class WriteTxnMarkersResponse
extends AbstractResponse {
    private static final String TXN_MARKERS_KEY_NAME = "transaction_markers";
    private static final String PRODUCER_ID_KEY_NAME = "producer_id";
    private static final String TOPICS_KEY_NAME = "topics";
    private static final String PARTITIONS_KEY_NAME = "partitions";
    private static final Schema WRITE_TXN_MARKERS_PARTITION_ERROR_RESPONSE_V0 = new Schema(CommonFields.PARTITION_ID, CommonFields.ERROR_CODE);
    private static final Schema WRITE_TXN_MARKERS_ENTRY_V0 = new Schema(new Field("producer_id", Type.INT64, "Current producer id in use by the transactional id."), new Field("topics", new ArrayOf(new Schema(CommonFields.TOPIC_NAME, new Field("partitions", new ArrayOf(WRITE_TXN_MARKERS_PARTITION_ERROR_RESPONSE_V0)))), "Errors per partition from writing markers."));
    private static final Schema WRITE_TXN_MARKERS_RESPONSE_V0 = new Schema(new Field("transaction_markers", new ArrayOf(WRITE_TXN_MARKERS_ENTRY_V0), "Errors per partition from writing markers."));
    private final Map<Long, Map<TopicPartition, Errors>> errors;

    public static Schema[] schemaVersions() {
        return new Schema[]{WRITE_TXN_MARKERS_RESPONSE_V0};
    }

    public WriteTxnMarkersResponse(Map<Long, Map<TopicPartition, Errors>> errors) {
        this.errors = errors;
    }

    public WriteTxnMarkersResponse(Struct struct) {
        Object[] responseArray;
        HashMap<Long, Map<TopicPartition, Errors>> errors = new HashMap<Long, Map<TopicPartition, Errors>>();
        for (Object responseObj : responseArray = struct.getArray(TXN_MARKERS_KEY_NAME)) {
            Object[] topicPartitionsArray;
            Struct responseStruct = (Struct)responseObj;
            long producerId = responseStruct.getLong(PRODUCER_ID_KEY_NAME);
            HashMap<TopicPartition, Errors> errorPerPartition = new HashMap<TopicPartition, Errors>();
            for (Object topicPartitionObj : topicPartitionsArray = responseStruct.getArray(TOPICS_KEY_NAME)) {
                Struct topicPartitionStruct = (Struct)topicPartitionObj;
                String topic = topicPartitionStruct.get(CommonFields.TOPIC_NAME);
                for (Object partitionObj : topicPartitionStruct.getArray(PARTITIONS_KEY_NAME)) {
                    Struct partitionStruct = (Struct)partitionObj;
                    Integer partition = partitionStruct.get(CommonFields.PARTITION_ID);
                    Errors error = Errors.forCode(partitionStruct.get(CommonFields.ERROR_CODE));
                    errorPerPartition.put(new TopicPartition(topic, partition), error);
                }
            }
            errors.put(producerId, errorPerPartition);
        }
        this.errors = errors;
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.WRITE_TXN_MARKERS.responseSchema(version));
        Object[] responsesArray = new Object[this.errors.size()];
        int k = 0;
        for (Map.Entry<Long, Map<TopicPartition, Errors>> responseEntry : this.errors.entrySet()) {
            Struct responseStruct = struct.instance(TXN_MARKERS_KEY_NAME);
            responseStruct.set(PRODUCER_ID_KEY_NAME, (Object)responseEntry.getKey());
            Map<TopicPartition, Errors> partitionAndErrors = responseEntry.getValue();
            Map<String, Map<Integer, Errors>> mappedPartitions = CollectionUtils.groupPartitionDataByTopic(partitionAndErrors);
            Object[] partitionsArray = new Object[mappedPartitions.size()];
            int i = 0;
            for (Map.Entry<String, Map<Integer, Errors>> topicAndPartitions : mappedPartitions.entrySet()) {
                Struct topicPartitionsStruct = responseStruct.instance(TOPICS_KEY_NAME);
                topicPartitionsStruct.set(CommonFields.TOPIC_NAME, topicAndPartitions.getKey());
                Map<Integer, Errors> partitionIdAndErrors = topicAndPartitions.getValue();
                Object[] partitionAndErrorsArray = new Object[partitionIdAndErrors.size()];
                int j = 0;
                for (Map.Entry<Integer, Errors> partitionAndError : partitionIdAndErrors.entrySet()) {
                    Struct partitionAndErrorStruct = topicPartitionsStruct.instance(PARTITIONS_KEY_NAME);
                    partitionAndErrorStruct.set(CommonFields.PARTITION_ID, partitionAndError.getKey());
                    partitionAndErrorStruct.set(CommonFields.ERROR_CODE, partitionAndError.getValue().code());
                    partitionAndErrorsArray[j++] = partitionAndErrorStruct;
                }
                topicPartitionsStruct.set(PARTITIONS_KEY_NAME, (Object)partitionAndErrorsArray);
                partitionsArray[i++] = topicPartitionsStruct;
            }
            responseStruct.set(TOPICS_KEY_NAME, (Object)partitionsArray);
            responsesArray[k++] = responseStruct;
        }
        struct.set(TXN_MARKERS_KEY_NAME, (Object)responsesArray);
        return struct;
    }

    public Map<TopicPartition, Errors> errors(long producerId) {
        return this.errors.get(producerId);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        for (Map<TopicPartition, Errors> allErrors : this.errors.values()) {
            for (Errors error : allErrors.values()) {
                this.updateErrorCounts(errorCounts, error);
            }
        }
        return errorCounts;
    }

    public static WriteTxnMarkersResponse parse(ByteBuffer buffer, short version) {
        return new WriteTxnMarkersResponse(ApiKeys.WRITE_TXN_MARKERS.parseResponse(version, buffer));
    }
}

