/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.encoded;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.type.DataTypePhysicalVariation;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.DebugUtils;
import org.apache.hadoop.hive.llap.io.api.impl.LlapIoImpl;
import org.apache.hadoop.hive.llap.io.encoded.SerDeEncodedDataReader;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorDeserializeRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.fast.DeserializeRead;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.lazy.LazySerDeParameters;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.lazy.fast.LazySimpleDeserializeRead;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazySimpleStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.TextInputFormat;

class VectorDeserializeOrcWriter
extends SerDeEncodedDataReader.EncodingWriter
implements Runnable {
    private final VectorizedRowBatchCtx vrbCtx;
    private Writer orcWriter;
    private final LazySimpleDeserializeRead deserializeRead;
    private final VectorDeserializeRow<?> vectorDeserializeRow;
    private final StructObjectInspector destinationOi;
    private final boolean usesSourceIncludes;
    private final List<Integer> sourceIncludes;
    private final boolean isAsync;
    private final ConcurrentLinkedQueue<WriteOperation> queue;
    private AsyncCallback completion;
    private Future<?> future;
    private final boolean[] cacheIncludes;
    private VectorizedRowBatch sourceBatch;
    private VectorizedRowBatch destinationBatch;
    private List<VectorizedRowBatch> currentBatches;
    private final ExecutorService encodeExecutor;

    public static SerDeEncodedDataReader.EncodingWriter create(InputFormat<?, ?> sourceIf, Deserializer serDe, Map<Path, PartitionDesc> parts, Configuration daemonConf, Configuration jobConf, Path splitPath, StructObjectInspector sourceOi, List<Integer> sourceIncludes, boolean[] cacheIncludes, int allocSize, ExecutorService encodeExecutor) throws IOException {
        if (!(HiveConf.getBoolVar((Configuration)daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_ENCODE_VECTOR_SERDE_ENABLED) && HiveConf.getBoolVar((Configuration)jobConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_ENCODE_VECTOR_SERDE_ENABLED) && sourceIf instanceof TextInputFormat && serDe instanceof LazySimpleSerDe)) {
            return new SerDeEncodedDataReader.DeserializerOrcWriter(serDe, sourceOi, allocSize);
        }
        Path path = splitPath.getFileSystem(jobConf).makeQualified(splitPath);
        PartitionDesc partDesc = (PartitionDesc)HiveFileFormatUtils.getFromPathRecursively(parts, (Path)path, null);
        if (partDesc == null) {
            LlapIoImpl.LOG.info("Not using VertorDeserializeOrcWriter: no partition desc for " + path);
            return new SerDeEncodedDataReader.DeserializerOrcWriter(serDe, sourceOi, allocSize);
        }
        Properties tblProps = partDesc.getTableDesc().getProperties();
        if ("true".equalsIgnoreCase(tblProps.getProperty("serialization.last.column.takes.rest"))) {
            LlapIoImpl.LOG.info("Not using VertorDeserializeOrcWriter due to serialization.last.column.takes.rest");
            return new SerDeEncodedDataReader.DeserializerOrcWriter(serDe, sourceOi, allocSize);
        }
        for (StructField sf : sourceOi.getAllStructFieldRefs()) {
            ObjectInspector.Category c = sf.getFieldObjectInspector().getCategory();
            if (c == ObjectInspector.Category.PRIMITIVE) continue;
            LlapIoImpl.LOG.info("Not using VertorDeserializeOrcWriter: " + c + " is not supported");
            return new SerDeEncodedDataReader.DeserializerOrcWriter(serDe, sourceOi, allocSize);
        }
        LlapIoImpl.LOG.info("Creating VertorDeserializeOrcWriter for " + path);
        return new VectorDeserializeOrcWriter(jobConf, tblProps, sourceOi, sourceIncludes, cacheIncludes, allocSize, encodeExecutor);
    }

    private VectorDeserializeOrcWriter(Configuration conf, Properties tblProps, StructObjectInspector sourceOi, List<Integer> sourceIncludes, boolean[] cacheIncludes, int allocSize, ExecutorService encodeExecutor) throws IOException {
        super(sourceOi, allocSize);
        this.vrbCtx = VectorDeserializeOrcWriter.createVrbCtx(sourceOi, tblProps, conf);
        this.sourceIncludes = sourceIncludes;
        this.cacheIncludes = cacheIncludes;
        this.sourceBatch = this.vrbCtx.createVectorizedRowBatch();
        this.deserializeRead = new LazySimpleDeserializeRead(this.vrbCtx.getRowColumnTypeInfos(), this.vrbCtx.getRowdataTypePhysicalVariations(), true, VectorDeserializeOrcWriter.createSerdeParams(conf, tblProps));
        this.vectorDeserializeRow = new VectorDeserializeRow((DeserializeRead)this.deserializeRead);
        int colCount = this.vrbCtx.getRowColumnTypeInfos().length;
        boolean[] includes = null;
        boolean bl = this.usesSourceIncludes = sourceIncludes.size() < colCount;
        if (this.usesSourceIncludes) {
            this.destinationBatch = new VectorizedRowBatch(sourceIncludes.size());
            includes = new boolean[colCount];
            int inclBatchIx = 0;
            ArrayList<String> childNames = new ArrayList<String>(sourceIncludes.size());
            ArrayList<ObjectInspector> childOis = new ArrayList<ObjectInspector>(sourceIncludes.size());
            List sourceFields = sourceOi.getAllStructFieldRefs();
            for (Integer columnId : sourceIncludes) {
                includes[columnId.intValue()] = true;
                assert (inclBatchIx <= columnId);
                this.destinationBatch.cols[inclBatchIx++] = this.sourceBatch.cols[columnId];
                StructField sourceField = (StructField)sourceFields.get(columnId);
                childNames.add(sourceField.getFieldName());
                childOis.add(sourceField.getFieldObjectInspector());
            }
            this.destinationOi = new LazySimpleStructObjectInspector(childNames, childOis, null, 0, null);
            this.destinationBatch.setPartitionInfo(sourceIncludes.size(), 0);
            if (LlapIoImpl.LOG.isDebugEnabled()) {
                LlapIoImpl.LOG.debug("Includes for deserializer are " + DebugUtils.toString((boolean[])includes));
            }
            try {
                this.vectorDeserializeRow.init(includes);
            }
            catch (HiveException e) {
                throw new IOException(e);
            }
        }
        this.destinationBatch = this.sourceBatch;
        this.destinationOi = sourceOi;
        try {
            this.vectorDeserializeRow.init();
        }
        catch (HiveException e) {
            throw new IOException(e);
        }
        this.isAsync = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_ENCODE_VECTOR_SERDE_ASYNC_ENABLED);
        if (this.isAsync) {
            this.currentBatches = new LinkedList<VectorizedRowBatch>();
            this.queue = new ConcurrentLinkedQueue();
        } else {
            this.queue = null;
            this.currentBatches = null;
        }
        this.encodeExecutor = encodeExecutor;
    }

    public void startAsync(AsyncCallback callback) {
        this.completion = callback;
        this.future = this.encodeExecutor.submit(this);
    }

    private static VectorizedRowBatchCtx createVrbCtx(StructObjectInspector oi, Properties tblProps, Configuration conf) throws IOException {
        boolean useDecimal64ColumnVectors = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZED_INPUT_FORMAT_SUPPORTS_ENABLED).equalsIgnoreCase("decimal_64");
        String serde = tblProps.getProperty("serialization.lib");
        String inputFormat = tblProps.getProperty("file.inputformat");
        boolean isTextFormat = inputFormat != null && inputFormat.equals(TextInputFormat.class.getName()) && serde != null && serde.equals(LazySimpleSerDe.class.getName());
        ArrayList<DataTypePhysicalVariation> dataTypePhysicalVariations = new ArrayList<DataTypePhysicalVariation>();
        if (isTextFormat) {
            StructTypeInfo structTypeInfo = (StructTypeInfo)TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)oi);
            int dataColumnCount = structTypeInfo.getAllStructFieldTypeInfos().size();
            for (int i = 0; i < dataColumnCount; ++i) {
                DecimalTypeInfo decimalTypeInfo;
                TypeInfo typeInfo;
                DataTypePhysicalVariation dataTypePhysicalVariation = DataTypePhysicalVariation.NONE;
                if (useDecimal64ColumnVectors && (typeInfo = (TypeInfo)structTypeInfo.getAllStructFieldTypeInfos().get(i)) instanceof DecimalTypeInfo && HiveDecimalWritable.isPrecisionDecimal64((int)(decimalTypeInfo = (DecimalTypeInfo)typeInfo).precision())) {
                    dataTypePhysicalVariation = DataTypePhysicalVariation.DECIMAL_64;
                }
                dataTypePhysicalVariations.add(dataTypePhysicalVariation);
            }
        }
        VectorizedRowBatchCtx vrbCtx = new VectorizedRowBatchCtx();
        try {
            vrbCtx.init(oi, new String[0]);
        }
        catch (HiveException e) {
            throw new IOException(e);
        }
        if (!dataTypePhysicalVariations.isEmpty()) {
            vrbCtx.setRowDataTypePhysicalVariations(dataTypePhysicalVariations.toArray(new DataTypePhysicalVariation[0]));
        }
        return vrbCtx;
    }

    private static LazySerDeParameters createSerdeParams(Configuration conf, Properties tblProps) throws IOException {
        try {
            return new LazySerDeParameters(conf, tblProps, LazySimpleSerDe.class.getName());
        }
        catch (SerDeException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void init(SerDeEncodedDataReader.CacheWriter cacheWriter, Configuration conf, Path path) throws IOException {
        this.orcWriter = super.createOrcWriter(cacheWriter, conf, path, this.destinationOi);
        this.cacheWriter = cacheWriter;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        block4: while (true) {
            WriteOperation op = null;
            int fallbackMs = 8;
            while (true) {
                if ((op = this.queue.poll()) != null) {
                    try {
                        if (!op.apply(this.orcWriter, this.cacheWriter)) continue block4;
                        LlapIoImpl.LOG.info("ORC encoder received a exit event");
                        this.completion.onComplete(this);
                        return;
                    }
                    catch (Exception e) {
                        LlapIoImpl.LOG.error("ORC encoder failed", (Throwable)e);
                        this.discardData();
                        return;
                    }
                }
                if (fallbackMs > 262144) {
                    LlapIoImpl.LOG.error("ORC encoder timed out waiting for input");
                    this.discardData();
                    return;
                }
                try {
                    Thread.sleep(fallbackMs);
                }
                catch (InterruptedException e) {
                    LlapIoImpl.LOG.error("ORC encoder interrupted waiting for input");
                    this.discardData();
                    return;
                }
                fallbackMs <<= 1;
            }
            break;
        }
    }

    private void discardData() {
        try {
            this.cacheWriter.discardData();
        }
        catch (Exception ex) {
            LlapIoImpl.LOG.error("Failed to close an async cache writer", (Throwable)ex);
        }
    }

    @Override
    public void writeOneRow(Writable row) throws IOException {
        if (this.sourceBatch.size == 1024) {
            this.flushBatch();
        }
        BinaryComparable binComp = (BinaryComparable)row;
        this.deserializeRead.set(binComp.getBytes(), 0, binComp.getLength());
        try {
            this.vectorDeserializeRow.deserialize(this.sourceBatch, this.sourceBatch.size++);
        }
        catch (Exception e) {
            throw new IOException("DeserializeRead detail: " + this.vectorDeserializeRow.getDetailedReadPositionString(), e);
        }
    }

    private void flushBatch() throws IOException {
        this.addBatchToWriter();
        if (!this.isAsync) {
            for (int c = 0; c < this.sourceBatch.cols.length; ++c) {
                ColumnVector colVector = this.sourceBatch.cols[c];
                if (colVector == null) continue;
                colVector.reset();
                colVector.init();
            }
            this.sourceBatch.selectedInUse = false;
            this.sourceBatch.size = 0;
            this.sourceBatch.endOfFile = false;
            this.propagateSourceBatchFieldsToDest();
        } else {
            this.sourceBatch = this.vrbCtx.createVectorizedRowBatch();
            if (this.usesSourceIncludes) {
                this.destinationBatch = new VectorizedRowBatch(this.sourceIncludes.size());
                int inclBatchIx = 0;
                for (Integer columnId : this.sourceIncludes) {
                    this.destinationBatch.cols[inclBatchIx++] = this.sourceBatch.cols[columnId];
                }
                this.destinationBatch.setPartitionInfo(this.sourceIncludes.size(), 0);
            } else {
                this.destinationBatch = this.sourceBatch;
            }
        }
    }

    private void propagateSourceBatchFieldsToDest() {
        if (this.destinationBatch == this.sourceBatch) {
            return;
        }
        this.destinationBatch.selectedInUse = this.sourceBatch.selectedInUse;
        this.destinationBatch.size = this.sourceBatch.size;
        this.destinationBatch.endOfFile = this.sourceBatch.endOfFile;
    }

    void addBatchToWriter() throws IOException {
        this.propagateSourceBatchFieldsToDest();
        if (!this.isAsync) {
            this.orcWriter.addRowBatch(this.destinationBatch);
        } else {
            for (ColumnVector cv : this.destinationBatch.cols) {
                if (cv == null) continue;
                cv.incRef();
            }
            this.currentBatches.add(this.destinationBatch);
            this.addWriteOp(new VrbOperation(this.destinationBatch));
        }
    }

    @Override
    public void flushIntermediateData() throws IOException {
        if (this.sourceBatch.size > 0) {
            this.flushBatch();
        }
    }

    @Override
    public void writeIntermediateFooter() throws IOException {
        if (this.isAsync) {
            this.addWriteOp(new IntermediateFooterOperation());
        } else {
            this.orcWriter.writeIntermediateFooter();
        }
    }

    private void addWriteOp(WriteOperation wo) throws AssertionError {
        if (this.queue.offer(wo)) {
            return;
        }
        throw new AssertionError((Object)"Queue full");
    }

    @Override
    public void setCurrentStripeOffsets(long currentKnownTornStart, long firstStartOffset, long lastStartOffset, long fileOffset) {
        if (this.isAsync) {
            this.addWriteOp(new SetStripeDataOperation(currentKnownTornStart, firstStartOffset, lastStartOffset, fileOffset));
        } else {
            this.cacheWriter.setCurrentStripeOffsets(currentKnownTornStart, firstStartOffset, lastStartOffset, fileOffset);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.sourceBatch.size > 0) {
            this.addBatchToWriter();
        }
        if (!this.isAsync) {
            this.orcWriter.close();
        } else {
            this.addWriteOp(new CloseOperation());
        }
    }

    @Override
    public List<VectorizedRowBatch> extractCurrentVrbs() {
        if (!this.isAsync) {
            return null;
        }
        List<VectorizedRowBatch> result = this.currentBatches;
        this.currentBatches = new LinkedList<VectorizedRowBatch>();
        return result;
    }

    public boolean[] getOriginalCacheIncludes() {
        return this.cacheIncludes;
    }

    @Override
    public boolean isOnlyWritingIncludedColumns() {
        return this.usesSourceIncludes;
    }

    public void interrupt() {
        if (this.future != null) {
            this.future.cancel(true);
        }
    }

    public static interface AsyncCallback {
        public void onComplete(VectorDeserializeOrcWriter var1);
    }

    static interface WriteOperation {
        public boolean apply(Writer var1, SerDeEncodedDataReader.CacheWriter var2) throws IOException;
    }

    private static class VrbOperation
    implements WriteOperation {
        private VectorizedRowBatch batch;

        public VrbOperation(VectorizedRowBatch batch) {
            this.batch = batch;
        }

        @Override
        public boolean apply(Writer writer, SerDeEncodedDataReader.CacheWriter cacheWriter) throws IOException {
            writer.addRowBatch(this.batch);
            for (ColumnVector cv : this.batch.cols) {
                if (cv != null) assert (cv.decRef() == 0);
            }
            return false;
        }
    }

    private static class IntermediateFooterOperation
    implements WriteOperation {
        private IntermediateFooterOperation() {
        }

        @Override
        public boolean apply(Writer writer, SerDeEncodedDataReader.CacheWriter cacheWriter) throws IOException {
            writer.writeIntermediateFooter();
            return false;
        }
    }

    private static class SetStripeDataOperation
    implements WriteOperation {
        private final long currentKnownTornStart;
        private final long firstStartOffset;
        private final long lastStartOffset;
        private final long fileOffset;

        public SetStripeDataOperation(long currentKnownTornStart, long firstStartOffset, long lastStartOffset, long fileOffset) {
            this.currentKnownTornStart = currentKnownTornStart;
            this.firstStartOffset = firstStartOffset;
            this.lastStartOffset = lastStartOffset;
            this.fileOffset = fileOffset;
        }

        @Override
        public boolean apply(Writer writer, SerDeEncodedDataReader.CacheWriter cacheWriter) throws IOException {
            cacheWriter.setCurrentStripeOffsets(this.currentKnownTornStart, this.firstStartOffset, this.lastStartOffset, this.fileOffset);
            return false;
        }
    }

    private static class CloseOperation
    implements WriteOperation {
        private CloseOperation() {
        }

        @Override
        public boolean apply(Writer writer, SerDeEncodedDataReader.CacheWriter cacheWriter) throws IOException {
            writer.close();
            return true;
        }
    }
}

