/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap;

import com.google.common.annotations.VisibleForTesting;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.FileSystem;
import org.apache.tez.common.counters.FileSystemCounter;
import org.apache.tez.common.counters.TezCounters;

public class LlapThreadLocalStatistics {
    @VisibleForTesting
    Map<String, LlapFileSystemStatisticsData> schemeToThreadLocalStats = new HashMap<String, LlapFileSystemStatisticsData>();
    @VisibleForTesting
    long cpuTime;
    @VisibleForTesting
    long userTime;

    public LlapThreadLocalStatistics(ThreadMXBean mxBean) {
        this(mxBean, FileSystem.getAllStatistics());
    }

    public LlapThreadLocalStatistics(ThreadMXBean mxBean, List<FileSystem.Statistics> allStatistics) {
        this.cpuTime = mxBean == null ? -1L : mxBean.getCurrentThreadCpuTime();
        this.userTime = mxBean == null ? -1L : mxBean.getCurrentThreadUserTime();
        for (FileSystem.Statistics statistics : allStatistics) {
            this.schemeToThreadLocalStats.merge(statistics.getScheme(), new LlapFileSystemStatisticsData(statistics.getThreadStatistics()), (statsCurrent, statsNew) -> statsCurrent.merge(statistics.getThreadStatistics()));
        }
    }

    public LlapThreadLocalStatistics subtract(LlapThreadLocalStatistics other) {
        for (Map.Entry<String, LlapFileSystemStatisticsData> otherStats : other.schemeToThreadLocalStats.entrySet()) {
            this.schemeToThreadLocalStats.computeIfPresent(otherStats.getKey(), (thisScheme, stats) -> stats.subtract((LlapFileSystemStatisticsData)otherStats.getValue()));
        }
        this.cpuTime -= other.cpuTime;
        this.userTime -= other.userTime;
        return this;
    }

    public void fill(TezCounters tezCounters) {
        for (Map.Entry<String, LlapFileSystemStatisticsData> threadLocalStats : this.schemeToThreadLocalStats.entrySet()) {
            String scheme = threadLocalStats.getKey();
            LlapFileSystemStatisticsData stats = threadLocalStats.getValue();
            tezCounters.findCounter(scheme, FileSystemCounter.BYTES_READ).increment(stats.bytesRead);
            tezCounters.findCounter(scheme, FileSystemCounter.BYTES_WRITTEN).increment(stats.bytesWritten);
            tezCounters.findCounter(scheme, FileSystemCounter.READ_OPS).increment((long)stats.readOps);
            tezCounters.findCounter(scheme, FileSystemCounter.LARGE_READ_OPS).increment((long)stats.largeReadOps);
            tezCounters.findCounter(scheme, FileSystemCounter.WRITE_OPS).increment((long)stats.writeOps);
        }
        if (this.cpuTime >= 0L && this.userTime >= 0L) {
            tezCounters.findCounter((Enum)LlapExecutorCounters.EXECUTOR_CPU_NS).increment(this.cpuTime);
            tezCounters.findCounter((Enum)LlapExecutorCounters.EXECUTOR_USER_NS).increment(this.userTime);
        }
    }

    public String toString() {
        return String.format("LlapThreadLocalStatistics: %s", this.schemeToThreadLocalStats.toString());
    }

    public static class LlapFileSystemStatisticsData {
        long bytesRead;
        long bytesWritten;
        int readOps;
        int largeReadOps;
        int writeOps;

        public LlapFileSystemStatisticsData(FileSystem.Statistics.StatisticsData fsStats) {
            this.bytesRead = fsStats.getBytesRead();
            this.bytesWritten = fsStats.getBytesWritten();
            this.readOps = fsStats.getReadOps();
            this.largeReadOps = fsStats.getLargeReadOps();
            this.writeOps = fsStats.getWriteOps();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(" bytesRead: ").append(this.bytesRead);
            sb.append(" bytesWritten: ").append(this.bytesWritten);
            sb.append(" readOps: ").append(this.readOps);
            sb.append(" largeReadOps: ").append(this.largeReadOps);
            sb.append(" writeOps: ").append(this.writeOps);
            return sb.toString();
        }

        public LlapFileSystemStatisticsData merge(FileSystem.Statistics.StatisticsData other) {
            this.bytesRead += other.getBytesRead();
            this.bytesWritten += other.getBytesWritten();
            this.readOps += other.getReadOps();
            this.largeReadOps += other.getLargeReadOps();
            this.writeOps += other.getWriteOps();
            return this;
        }

        public LlapFileSystemStatisticsData subtract(LlapFileSystemStatisticsData other) {
            if (other == null) {
                return this;
            }
            this.bytesRead -= other.bytesRead;
            this.bytesWritten -= other.bytesWritten;
            this.readOps -= other.readOps;
            this.largeReadOps -= other.largeReadOps;
            this.writeOps -= other.writeOps;
            return this;
        }
    }

    public static enum LlapExecutorCounters {
        EXECUTOR_CPU_NS,
        EXECUTOR_USER_NS;

    }
}

