/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.parquet.Preconditions;
import org.apache.parquet.column.values.bloomfilter.BloomFilter;
import org.apache.parquet.hadoop.IndexCache;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.internal.column.columnindex.ColumnIndex;
import org.apache.parquet.internal.column.columnindex.OffsetIndex;

class PrefetchIndexCache
implements IndexCache {
    private final ParquetFileReader fileReader;
    private final Set<ColumnPath> columns;
    private final boolean freeCacheAfterGet;
    private Map<ColumnPath, ColumnIndex> columnIndexCache;
    private Map<ColumnPath, OffsetIndex> offsetIndexCache;
    private Map<ColumnPath, BloomFilter> bloomIndexCache;

    PrefetchIndexCache(ParquetFileReader fileReader, Set<ColumnPath> columns, boolean freeCacheAfterGet) {
        this.fileReader = fileReader;
        this.columns = columns;
        this.freeCacheAfterGet = freeCacheAfterGet;
    }

    @Override
    public void setBlockMetadata(BlockMetaData currentBlockMetadata) throws IOException {
        this.clean();
        this.columnIndexCache = this.readAllColumnIndexes(currentBlockMetadata);
        this.offsetIndexCache = this.readAllOffsetIndexes(currentBlockMetadata);
        this.bloomIndexCache = this.readAllBloomFilters(currentBlockMetadata);
    }

    @Override
    public ColumnIndex getColumnIndex(ColumnChunkMetaData chunk) throws IOException {
        ColumnPath columnPath = chunk.getPath();
        if (this.columns.contains(columnPath)) {
            Preconditions.checkState(this.columnIndexCache.containsKey(columnPath), "Not found cached ColumnIndex for column: %s with cache strategy: %s", (Object)columnPath.toDotString(), (Object)IndexCache.CacheStrategy.PREFETCH_BLOCK);
        }
        if (this.freeCacheAfterGet) {
            return this.columnIndexCache.remove(columnPath);
        }
        return this.columnIndexCache.get(columnPath);
    }

    @Override
    public OffsetIndex getOffsetIndex(ColumnChunkMetaData chunk) throws IOException {
        ColumnPath columnPath = chunk.getPath();
        if (this.columns.contains(columnPath)) {
            Preconditions.checkState(this.offsetIndexCache.containsKey(columnPath), "Not found cached OffsetIndex for column: %s with cache strategy: %s", (Object)columnPath.toDotString(), (Object)IndexCache.CacheStrategy.PREFETCH_BLOCK);
        }
        if (this.freeCacheAfterGet) {
            return this.offsetIndexCache.remove(columnPath);
        }
        return this.offsetIndexCache.get(columnPath);
    }

    @Override
    public BloomFilter getBloomFilter(ColumnChunkMetaData chunk) throws IOException {
        ColumnPath columnPath = chunk.getPath();
        if (this.columns.contains(columnPath)) {
            Preconditions.checkState(this.bloomIndexCache.containsKey(columnPath), "Not found cached BloomFilter for column: %s with cache strategy: %s", (Object)columnPath.toDotString(), (Object)IndexCache.CacheStrategy.PREFETCH_BLOCK);
        }
        if (this.freeCacheAfterGet) {
            return this.bloomIndexCache.remove(columnPath);
        }
        return this.bloomIndexCache.get(columnPath);
    }

    @Override
    public void clean() {
        if (this.columnIndexCache != null) {
            this.columnIndexCache.clear();
            this.columnIndexCache = null;
        }
        if (this.offsetIndexCache != null) {
            this.offsetIndexCache.clear();
            this.offsetIndexCache = null;
        }
        if (this.bloomIndexCache != null) {
            this.bloomIndexCache.clear();
            this.bloomIndexCache = null;
        }
    }

    private Map<ColumnPath, ColumnIndex> readAllColumnIndexes(BlockMetaData blockMetaData) throws IOException {
        HashMap<ColumnPath, ColumnIndex> columnIndexMap = new HashMap<ColumnPath, ColumnIndex>(this.columns.size());
        for (ColumnChunkMetaData chunk : blockMetaData.getColumns()) {
            if (!this.columns.contains(chunk.getPath())) continue;
            columnIndexMap.put(chunk.getPath(), this.fileReader.readColumnIndex(chunk));
        }
        return columnIndexMap;
    }

    private Map<ColumnPath, OffsetIndex> readAllOffsetIndexes(BlockMetaData blockMetaData) throws IOException {
        HashMap<ColumnPath, OffsetIndex> offsetIndexMap = new HashMap<ColumnPath, OffsetIndex>(this.columns.size());
        for (ColumnChunkMetaData chunk : blockMetaData.getColumns()) {
            if (!this.columns.contains(chunk.getPath())) continue;
            offsetIndexMap.put(chunk.getPath(), this.fileReader.readOffsetIndex(chunk));
        }
        return offsetIndexMap;
    }

    private Map<ColumnPath, BloomFilter> readAllBloomFilters(BlockMetaData blockMetaData) throws IOException {
        HashMap<ColumnPath, BloomFilter> bloomFilterMap = new HashMap<ColumnPath, BloomFilter>(this.columns.size());
        for (ColumnChunkMetaData chunk : blockMetaData.getColumns()) {
            if (!this.columns.contains(chunk.getPath())) continue;
            bloomFilterMap.put(chunk.getPath(), this.fileReader.readBloomFilter(chunk));
        }
        return bloomFilterMap;
    }
}

