/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.UUID;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public class UUIDUtil {
    private UUIDUtil() {
    }

    public static UUID convert(byte[] buf) {
        Preconditions.checkArgument(buf.length == 16, "UUID require 16 bytes");
        ByteBuffer bb = ByteBuffer.wrap(buf);
        bb.order(ByteOrder.BIG_ENDIAN);
        return UUIDUtil.convert(bb);
    }

    public static UUID convert(byte[] buf, int offset) {
        Preconditions.checkArgument(offset >= 0 && offset < buf.length, "Offset overflow, offset=%s, length=%s", offset, buf.length);
        Preconditions.checkArgument(offset + 16 <= buf.length, "UUID require 16 bytes, offset=%s, length=%s", offset, buf.length);
        ByteBuffer bb = ByteBuffer.wrap(buf, offset, 16);
        bb.order(ByteOrder.BIG_ENDIAN);
        return UUIDUtil.convert(bb);
    }

    public static UUID convert(ByteBuffer buf) {
        long mostSigBits = buf.getLong();
        long leastSigBits = buf.getLong();
        return new UUID(mostSigBits, leastSigBits);
    }

    public static byte[] convert(UUID value) {
        return UUIDUtil.convertToByteBuffer(value).array();
    }

    public static ByteBuffer convertToByteBuffer(UUID value) {
        return UUIDUtil.convertToByteBuffer(value, null);
    }

    public static ByteBuffer convertToByteBuffer(UUID value, ByteBuffer reuse) {
        ByteBuffer buffer = reuse != null ? reuse : ByteBuffer.allocate(16);
        buffer.order(ByteOrder.BIG_ENDIAN);
        buffer.putLong(0, value.getMostSignificantBits());
        buffer.putLong(8, value.getLeastSignificantBits());
        return buffer;
    }
}

