/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data.parquet;

import java.util.List;
import java.util.Map;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.data.parquet.BaseParquetReaders;
import org.apache.iceberg.parquet.ParquetValueReader;
import org.apache.iceberg.parquet.ParquetValueReaders;
import org.apache.iceberg.types.Types;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;

public class InternalReader<T extends StructLike>
extends BaseParquetReaders<T> {
    private static final InternalReader<?> INSTANCE = new InternalReader();

    private InternalReader() {
    }

    public static <T extends StructLike> ParquetValueReader<T> create(Schema expectedSchema, MessageType fileSchema) {
        return INSTANCE.createReader(expectedSchema, fileSchema);
    }

    public static <T extends StructLike> ParquetValueReader<T> create(Schema expectedSchema, MessageType fileSchema, Map<Integer, ?> idToConstant) {
        return INSTANCE.createReader(expectedSchema, fileSchema, idToConstant);
    }

    @Deprecated
    protected ParquetValueReader<T> createStructReader(List<Type> types, List<ParquetValueReader<?>> fieldReaders, Types.StructType structType) {
        return ParquetValueReaders.recordReader(fieldReaders, structType);
    }

    @Override
    protected ParquetValueReader<T> createStructReader(List<ParquetValueReader<?>> fieldReaders, Types.StructType structType) {
        return ParquetValueReaders.recordReader(fieldReaders, structType);
    }

    @Override
    protected ParquetValueReader<?> fixedReader(ColumnDescriptor desc) {
        return new ParquetValueReaders.BytesReader(desc);
    }

    @Override
    protected ParquetValueReader<?> dateReader(ColumnDescriptor desc) {
        return new ParquetValueReaders.UnboxedReader(desc);
    }

    @Override
    protected ParquetValueReader<?> timeReader(ColumnDescriptor desc) {
        return ParquetValueReaders.times(desc);
    }

    @Override
    protected ParquetValueReader<?> timestampReader(ColumnDescriptor desc, boolean isAdjustedToUTC) {
        return ParquetValueReaders.timestamps(desc);
    }
}

