/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.orc;

import java.util.ArrayList;
import java.util.List;
import org.apache.hive.iceberg.org.apache.orc.TypeDescription;
import org.apache.iceberg.Schema;
import org.apache.iceberg.orc.ORCSchemaUtil;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public abstract class OrcSchemaWithTypeVisitor<T> {
    public static <T> T visit(Schema iSchema, TypeDescription schema, OrcSchemaWithTypeVisitor<T> visitor) {
        return OrcSchemaWithTypeVisitor.visit(iSchema.asStruct(), schema, visitor);
    }

    public static <T> T visit(Type iType, TypeDescription schema, OrcSchemaWithTypeVisitor<T> visitor) {
        switch (schema.getCategory()) {
            case STRUCT: {
                String structType = schema.getAttributeValue("iceberg.struct-type");
                if ("VARIANT".equalsIgnoreCase(structType)) {
                    return OrcSchemaWithTypeVisitor.visitVariant(iType != null ? iType.asVariantType() : null, schema, visitor);
                }
                return OrcSchemaWithTypeVisitor.visitRecord(iType != null ? iType.asStructType() : null, schema, visitor);
            }
            case UNION: {
                throw new UnsupportedOperationException("Cannot handle " + schema);
            }
            case LIST: {
                Types.ListType list = iType != null ? iType.asListType() : null;
                return visitor.list(list, schema, OrcSchemaWithTypeVisitor.visit(list != null ? list.elementType() : null, schema.getChildren().get(0), visitor));
            }
            case MAP: {
                Types.MapType map = iType != null ? iType.asMapType() : null;
                return visitor.map(map, schema, OrcSchemaWithTypeVisitor.visit(map != null ? map.keyType() : null, schema.getChildren().get(0), visitor), OrcSchemaWithTypeVisitor.visit(map != null ? map.valueType() : null, schema.getChildren().get(1), visitor));
            }
        }
        return visitor.primitive(iType != null ? iType.asPrimitiveType() : null, schema);
    }

    private static <T> T visitRecord(Types.StructType struct, TypeDescription record, OrcSchemaWithTypeVisitor<T> visitor) {
        List<TypeDescription> fields = record.getChildren();
        List<String> names = record.getFieldNames();
        ArrayList<T> results = Lists.newArrayListWithExpectedSize(fields.size());
        for (TypeDescription field : fields) {
            int fieldId = ORCSchemaUtil.fieldId(field);
            Types.NestedField iField = struct != null ? struct.field(fieldId) : null;
            results.add(OrcSchemaWithTypeVisitor.visit(iField != null ? iField.type() : null, field, visitor));
        }
        return visitor.record(struct, record, names, results);
    }

    private static <T> T visitVariant(Types.VariantType iVariant, TypeDescription variant, OrcSchemaWithTypeVisitor<T> visitor) {
        List<String> names = variant.getFieldNames();
        Preconditions.checkArgument(names.size() == 2 && "metadata".equals(names.get(0)) && "value".equals(names.get(1)), "Invalid variant metadata fields: %s", (Object)String.join((CharSequence)", ", names));
        List<TypeDescription> children = variant.getChildren();
        T metadataResult = OrcSchemaWithTypeVisitor.visit((Type)null, children.get(0), visitor);
        T valueResult = OrcSchemaWithTypeVisitor.visit((Type)null, children.get(1), visitor);
        return visitor.variant(iVariant, variant, metadataResult, valueResult);
    }

    public T record(Types.StructType iStruct, TypeDescription record, List<String> names, List<T> fields) {
        return null;
    }

    public T list(Types.ListType iList, TypeDescription array, T element) {
        return null;
    }

    public T map(Types.MapType iMap, TypeDescription map, T key, T value) {
        return null;
    }

    public T variant(Types.VariantType iVariant, TypeDescription variant, T metadata, T value) {
        throw new UnsupportedOperationException("Variant is not supported");
    }

    public T primitive(Type.PrimitiveType iPrimitive, TypeDescription primitive) {
        return null;
    }
}

