/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.writer;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Table;
import org.apache.iceberg.deletes.DeleteGranularity;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.mr.hive.IcebergTableUtil;
import org.apache.iceberg.mr.hive.writer.HiveFileWriterFactory;
import org.apache.iceberg.mr.hive.writer.HiveIcebergCopyOnWriteRecordWriter;
import org.apache.iceberg.mr.hive.writer.HiveIcebergDeleteWriter;
import org.apache.iceberg.mr.hive.writer.HiveIcebergRecordWriter;
import org.apache.iceberg.mr.hive.writer.HiveIcebergWriter;
import org.apache.iceberg.mr.hive.writer.HiveIcebergWriterBase;
import org.apache.iceberg.mr.hive.writer.WriterRegistry;
import org.apache.iceberg.util.PropertyUtil;

public class WriterBuilder {
    private final Table table;
    private final Context context;
    private String tableName;
    private TaskAttemptID attemptID;
    private String queryId;
    private Context.Operation operation;
    private static AtomicInteger operationNum = new AtomicInteger(0);
    public static final String ICEBERG_DELETE_SKIPROWDATA = "iceberg.delete.skiprowdata";
    public static final boolean ICEBERG_DELETE_SKIPROWDATA_DEFAULT = true;

    private WriterBuilder(Table table) {
        this.table = table;
        this.context = new Context(table.properties());
    }

    public static WriterBuilder builderFor(Table table) {
        return new WriterBuilder(table);
    }

    public WriterBuilder tableName(String newTableName) {
        this.tableName = newTableName;
        return this;
    }

    public WriterBuilder attemptID(TaskAttemptID newAttemptID) {
        this.attemptID = newAttemptID;
        return this;
    }

    public WriterBuilder queryId(String newQueryId) {
        this.queryId = newQueryId;
        return this;
    }

    public WriterBuilder operation(Context.Operation newOperation) {
        this.operation = newOperation;
        return this;
    }

    public WriterBuilder hasOrdering(boolean inputOrdered) {
        this.context.inputOrdered = inputOrdered;
        if (IcebergTableUtil.isFanoutEnabled(this.table.properties()) && !inputOrdered) {
            this.context.useFanoutWriter = true;
        }
        return this;
    }

    public WriterBuilder isMergeTask(boolean isMergeTaskEnabled) {
        this.context.isMergeTask = isMergeTaskEnabled;
        return this;
    }

    public HiveIcebergWriter build() {
        HiveIcebergWriterBase writer;
        int partitionId = this.attemptID.getTaskID().getId();
        int taskId = this.attemptID.getId();
        String operationId = this.queryId + "-" + this.attemptID.getJobID() + "-" + operationNum.incrementAndGet();
        OutputFileFactory dataFileFactory = OutputFileFactory.builderFor(this.table, partitionId, taskId).format(this.context.dataFileFormat()).operationId(operationId).build();
        OutputFileFactory deleteFileFactory = OutputFileFactory.builderFor(this.table, partitionId, taskId).format(this.context.deleteFileFormat()).operationId(operationId).suffix("pos-deletes").build();
        HiveFileWriterFactory writerFactory = HiveFileWriterFactory.builderFor(this.table).dataFileFormat(this.context.dataFileFormat()).dataSchema(this.table.schema()).deleteFileFormat(this.context.deleteFileFormat()).positionDeleteRowSchema(this.context.skipRowData() || !this.context.inputOrdered() ? null : this.table.schema()).build();
        boolean isCOW = IcebergTableUtil.isCopyOnWriteMode(this.operation, this.table.properties()::getOrDefault);
        if (isCOW) {
            writer = new HiveIcebergCopyOnWriteRecordWriter(this.table, writerFactory, dataFileFactory, this.context);
        } else {
            switch (this.operation) {
                case DELETE: {
                    writer = new HiveIcebergDeleteWriter(this.table, writerFactory, deleteFileFactory, this.context);
                    break;
                }
                case OTHER: {
                    writer = new HiveIcebergRecordWriter(this.table, writerFactory, dataFileFactory, this.context);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported operation when creating IcebergRecordWriter: " + this.operation.name());
                }
            }
        }
        WriterRegistry.registerWriter(this.attemptID, this.tableName, writer);
        return writer;
    }

    static class Context {
        private final FileFormat dataFileFormat;
        private final long targetDataFileSize;
        private final FileFormat deleteFileFormat;
        private final long targetDeleteFileSize;
        private final DeleteGranularity deleteGranularity;
        private boolean useFanoutWriter;
        private boolean inputOrdered;
        private boolean isMergeTask;
        private final boolean skipRowData;

        Context(Map<String, String> properties) {
            String dataFileFormatName = properties.getOrDefault("write.format.default", "parquet");
            this.dataFileFormat = FileFormat.valueOf(dataFileFormatName.toUpperCase(Locale.ENGLISH));
            this.targetDataFileSize = PropertyUtil.propertyAsLong(properties, "write.target-file-size-bytes", 0x20000000L);
            String deleteFileFormatName = properties.getOrDefault("write.delete.format.default", dataFileFormatName);
            this.deleteFileFormat = FileFormat.valueOf(deleteFileFormatName.toUpperCase(Locale.ENGLISH));
            this.targetDeleteFileSize = PropertyUtil.propertyAsLong(properties, "write.delete.target-file-size-bytes", 0x20000000L);
            this.skipRowData = PropertyUtil.propertyAsBoolean(properties, WriterBuilder.ICEBERG_DELETE_SKIPROWDATA, true);
            this.deleteGranularity = DeleteGranularity.PARTITION;
        }

        FileFormat dataFileFormat() {
            return this.dataFileFormat;
        }

        long targetDataFileSize() {
            return this.targetDataFileSize;
        }

        FileFormat deleteFileFormat() {
            return this.deleteFileFormat;
        }

        long targetDeleteFileSize() {
            return this.targetDeleteFileSize;
        }

        DeleteGranularity deleteGranularity() {
            return this.deleteGranularity;
        }

        boolean useFanoutWriter() {
            return this.useFanoutWriter;
        }

        boolean inputOrdered() {
            return this.inputOrdered;
        }

        boolean isMergeTask() {
            return this.isMergeTask;
        }

        boolean skipRowData() {
            return this.skipRowData;
        }
    }
}

