/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.metrics;

import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.metrics.ScanMetrics;
import org.apache.iceberg.util.ContentFileUtil;
import org.apache.iceberg.util.ScanTaskUtil;

public class ScanMetricsUtil {
    private ScanMetricsUtil() {
    }

    public static void indexedDeleteFile(ScanMetrics metrics, DeleteFile deleteFile) {
        metrics.indexedDeleteFiles().increment();
        if (deleteFile.content() == FileContent.POSITION_DELETES) {
            if (ContentFileUtil.isDV(deleteFile)) {
                metrics.dvs().increment();
            } else {
                metrics.positionalDeleteFiles().increment();
            }
        } else if (deleteFile.content() == FileContent.EQUALITY_DELETES) {
            metrics.equalityDeleteFiles().increment();
        }
    }

    public static void fileTask(ScanMetrics metrics, DataFile dataFile, DeleteFile[] deleteFiles) {
        metrics.totalFileSizeInBytes().increment(dataFile.fileSizeInBytes());
        metrics.resultDataFiles().increment();
        metrics.resultDeleteFiles().increment(deleteFiles.length);
        long deletesSizeInBytes = 0L;
        for (DeleteFile deleteFile : deleteFiles) {
            deletesSizeInBytes += ScanTaskUtil.contentSizeInBytes(deleteFile);
        }
        metrics.totalDeleteFileSizeInBytes().increment(deletesSizeInBytes);
    }
}

