/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapred.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableOutputCommitter;
import org.apache.hadoop.hbase.mapreduce.TableOutputFormat;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.hbase.PutWritable;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveHBaseTableOutputFormat
extends TableOutputFormat<ImmutableBytesWritable>
implements HiveOutputFormat<ImmutableBytesWritable, Object> {
    static final Logger LOG = LoggerFactory.getLogger(HiveHBaseTableOutputFormat.class);

    public void checkOutputSpecs(FileSystem fs, JobConf jc) throws IOException {
        if (UserGroupInformation.getCurrentUser().hasKerberosCredentials()) {
            TableMapReduceUtil.initCredentials((JobConf)jc);
        }
        String hbaseTableName = jc.get("hbase.table.name");
        jc.set("hbase.mapred.outputtable", hbaseTableName);
        Job job = new Job((Configuration)jc);
        JobContext jobContext = ShimLoader.getHadoopShims().newJobContext(job);
        try {
            this.checkOutputSpecs(jobContext);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public RecordWriter<ImmutableBytesWritable, Object> getRecordWriter(FileSystem fileSystem, JobConf jobConf, String name, Progressable progressable) throws IOException {
        return this.getMyRecordWriter(jobConf);
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new TableOutputCommitter();
    }

    public FileSinkOperator.RecordWriter getHiveRecordWriter(JobConf jobConf, Path finalOutPath, Class<? extends Writable> valueClass, boolean isCompressed, Properties tableProperties, Progressable progress) throws IOException {
        return this.getMyRecordWriter(jobConf);
    }

    private MyRecordWriter getMyRecordWriter(JobConf jobConf) throws IOException {
        String hbaseTableName = jobConf.get("hbase.table.name");
        jobConf.set("hbase.mapred.outputtable", hbaseTableName);
        boolean walEnabled = HiveConf.getBoolVar((Configuration)jobConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_HBASE_WAL_ENABLED);
        Connection conn = ConnectionFactory.createConnection((Configuration)HBaseConfiguration.create((Configuration)jobConf));
        BufferedMutator table = conn.getBufferedMutator(TableName.valueOf((String)hbaseTableName));
        return new MyRecordWriter(table, conn, walEnabled);
    }

    private static class MyRecordWriter
    implements RecordWriter<ImmutableBytesWritable, Object>,
    FileSinkOperator.RecordWriter {
        private final BufferedMutator m_table;
        private final boolean m_walEnabled;
        private final Connection m_connection;

        public MyRecordWriter(BufferedMutator table, Connection connection, boolean walEnabled) {
            this.m_table = table;
            this.m_walEnabled = walEnabled;
            this.m_connection = connection;
        }

        public void close(Reporter reporter) throws IOException {
            this.m_table.close();
        }

        public void write(ImmutableBytesWritable key, Object value) throws IOException {
            Put put;
            if (value instanceof Put) {
                put = (Put)value;
            } else if (value instanceof PutWritable) {
                put = new Put(((PutWritable)value).getPut());
            } else {
                throw new IllegalArgumentException("Illegal Argument " + (value == null ? "null" : value.getClass().getName()));
            }
            if (this.m_walEnabled) {
                put.setDurability(Durability.SYNC_WAL);
            } else {
                put.setDurability(Durability.SKIP_WAL);
            }
            this.m_table.mutate((Mutation)put);
        }

        protected void finalize() throws Throwable {
            try {
                this.m_table.close();
                this.m_connection.close();
            }
            finally {
                super.finalize();
            }
        }

        public void write(Writable w) throws IOException {
            this.write(null, (Object)w);
        }

        public void close(boolean abort) throws IOException {
            this.close(null);
        }
    }
}

