/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.hbase.HBaseScanRange;
import org.apache.hadoop.hive.ql.index.IndexPredicateAnalyzer;
import org.apache.hadoop.hive.ql.index.IndexSearchCondition;
import org.apache.hadoop.hive.ql.metadata.HiveStoragePredicateHandler;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHBaseKeyPredicateDecomposer {
    public static final Logger LOG = LoggerFactory.getLogger(AbstractHBaseKeyPredicateDecomposer.class);

    public HiveStoragePredicateHandler.DecomposedPredicate decomposePredicate(String keyColName, ExprNodeDesc predicate) {
        IndexPredicateAnalyzer analyzer = IndexPredicateAnalyzer.createAnalyzer((boolean)true);
        analyzer.allowColumnName(keyColName);
        analyzer.setAcceptsFields(true);
        analyzer.setFieldValidator(this.getFieldValidator());
        HiveStoragePredicateHandler.DecomposedPredicate decomposed = new HiveStoragePredicateHandler.DecomposedPredicate();
        ArrayList<IndexSearchCondition> conditions = new ArrayList<IndexSearchCondition>();
        decomposed.residualPredicate = (ExprNodeGenericFuncDesc)analyzer.analyzePredicate(predicate, conditions);
        if (!conditions.isEmpty()) {
            decomposed.pushedPredicate = analyzer.translateSearchConditions(conditions);
            try {
                decomposed.pushedPredicateObject = this.getScanRange(conditions);
            }
            catch (Exception e) {
                LOG.warn("Failed to decompose predicates", (Throwable)e);
                return null;
            }
        }
        return decomposed;
    }

    protected abstract HBaseScanRange getScanRange(List<IndexSearchCondition> var1) throws Exception;

    protected IndexPredicateAnalyzer.FieldValidator getFieldValidator() {
        return null;
    }
}

