/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RestrictedConfigChecker {
    private static final Logger LOG = LoggerFactory.getLogger(RestrictedConfigChecker.class);
    private final List<HiveConf.ConfVars> restrictedHiveConf = new ArrayList<HiveConf.ConfVars>();
    private final List<String> restrictedNonHiveConf = new ArrayList<String>();
    private final HiveConf initConf;

    RestrictedConfigChecker(HiveConf initConf) {
        this.initConf = initConf;
        String[] restrictedConfigs = HiveConf.getTrimmedStringsVar(initConf, HiveConf.ConfVars.HIVE_SERVER2_TEZ_SESSION_RESTRICTED_CONFIGS);
        if (restrictedConfigs == null || restrictedConfigs.length == 0) {
            return;
        }
        HashMap<String, HiveConf.ConfVars> confVars = HiveConf.getOrCreateReverseMap();
        for (String confName : restrictedConfigs) {
            if (confName == null || confName.isEmpty()) continue;
            HiveConf.ConfVars cv = confVars.get(confName = confName.toLowerCase());
            if (cv != null) {
                this.restrictedHiveConf.add(cv);
                continue;
            }
            LOG.warn("A restricted config " + confName + " is not recognized as a Hive setting.");
            this.restrictedNonHiveConf.add(confName);
        }
    }

    public void validate(HiveConf conf) throws HiveException {
        String serverValue;
        String userValue;
        for (HiveConf.ConfVars confVars : this.restrictedHiveConf) {
            userValue = HiveConf.getVarWithoutType(conf, confVars);
            serverValue = HiveConf.getVarWithoutType(this.initConf, confVars);
            this.validateRestrictedConfigValues(confVars.varname, userValue, serverValue);
        }
        for (String string : this.restrictedNonHiveConf) {
            userValue = conf.get(string);
            serverValue = this.initConf.get(string);
            this.validateRestrictedConfigValues(string, userValue, serverValue);
        }
    }

    private void validateRestrictedConfigValues(String var, String userValue, String serverValue) throws HiveException {
        if (userValue == null != (serverValue == null) || userValue != null && !userValue.equals(serverValue)) {
            String logValue = this.initConf.isHiddenConfig(var) ? "(hidden)" : serverValue;
            throw new HiveException(var + " is restricted from being set; server is configured" + " to use " + logValue + ", but the query configuration specifies " + userValue);
        }
    }
}

