/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.contrib.genericudf.example;

import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveWritableObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;

@Description(name="add10", value="_FUNC_(x) - returns 10 plus the original value of x", extended="Example:\n  > SELECT _FUNC_(0) FROM src LIMIT 1;\n  10\n  > SELECT _FUNC_(-5) FROM src LIMIT 1;\n  5")
public class GenericUDFAdd10
extends GenericUDF {
    private transient PrimitiveObjectInspector.PrimitiveCategory inputType;
    private final DoubleWritable resultDouble = new DoubleWritable();
    private final LongWritable resultLong = new LongWritable();
    private final IntWritable resultInt = new IntWritable();
    private final HiveDecimalWritable resultDecimal = new HiveDecimalWritable();
    private transient PrimitiveObjectInspector argumentOI;
    private transient ObjectInspectorConverters.Converter inputConverter;

    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 1) {
            throw new UDFArgumentLengthException("ADD10() requires 1 argument, got " + arguments.length);
        }
        if (arguments[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentException("ADD10 only takes primitive types, got " + arguments[0].getTypeName());
        }
        this.argumentOI = (PrimitiveObjectInspector)arguments[0];
        this.inputType = this.argumentOI.getPrimitiveCategory();
        AbstractPrimitiveWritableObjectInspector outputOI = null;
        switch (this.inputType) {
            case SHORT: 
            case BYTE: 
            case INT: {
                this.inputConverter = ObjectInspectorConverters.getConverter((ObjectInspector)arguments[0], (ObjectInspector)PrimitiveObjectInspectorFactory.writableIntObjectInspector);
                outputOI = PrimitiveObjectInspectorFactory.writableIntObjectInspector;
                break;
            }
            case LONG: {
                this.inputConverter = ObjectInspectorConverters.getConverter((ObjectInspector)arguments[0], (ObjectInspector)PrimitiveObjectInspectorFactory.writableLongObjectInspector);
                outputOI = PrimitiveObjectInspectorFactory.writableLongObjectInspector;
                break;
            }
            case FLOAT: 
            case STRING: 
            case DOUBLE: {
                this.inputConverter = ObjectInspectorConverters.getConverter((ObjectInspector)arguments[0], (ObjectInspector)PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
                outputOI = PrimitiveObjectInspectorFactory.writableDoubleObjectInspector;
                break;
            }
            case DECIMAL: {
                outputOI = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)((PrimitiveObjectInspector)arguments[0]).getTypeInfo());
                this.inputConverter = ObjectInspectorConverters.getConverter((ObjectInspector)arguments[0], (ObjectInspector)outputOI);
                break;
            }
            default: {
                throw new UDFArgumentException("ADD10 only takes SHORT/BYTE/INT/LONG/DOUBLE/FLOAT/STRING/DECIMAL types, got " + String.valueOf(this.inputType));
            }
        }
        return outputOI;
    }

    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object valObject = arguments[0].get();
        if (valObject == null) {
            return null;
        }
        switch (this.inputType) {
            case SHORT: 
            case BYTE: 
            case INT: {
                valObject = this.inputConverter.convert(valObject);
                this.resultInt.set(10 + ((IntWritable)valObject).get());
                return this.resultInt;
            }
            case LONG: {
                valObject = this.inputConverter.convert(valObject);
                this.resultLong.set(10L + ((LongWritable)valObject).get());
                return this.resultLong;
            }
            case FLOAT: 
            case STRING: 
            case DOUBLE: {
                valObject = this.inputConverter.convert(valObject);
                this.resultDouble.set(10.0 + ((DoubleWritable)valObject).get());
                return this.resultDouble;
            }
            case DECIMAL: {
                HiveDecimalObjectInspector decimalOI = (HiveDecimalObjectInspector)this.argumentOI;
                HiveDecimalWritable val = decimalOI.getPrimitiveWritableObject(valObject);
                if (val != null) {
                    this.resultDecimal.set(val.getHiveDecimal().add(HiveDecimal.create((String)"10")));
                    val = this.resultDecimal;
                }
                return val;
            }
        }
        throw new UDFArgumentException("ADD10 only takes SHORT/BYTE/INT/LONG/DOUBLE/FLOAT/STRING/DECIMAL types, got " + String.valueOf(this.inputType));
    }

    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString("add10", children);
    }
}

