/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo.mr;

import org.apache.accumulo.core.client.mapreduce.lib.impl.OutputConfigurator;
import org.apache.hadoop.conf.Configuration;

public class IndexOutputConfigurator
extends OutputConfigurator {
    public static void setIndexTableName(Class<?> implementingClass, Configuration conf, String tableName) {
        if (tableName != null) {
            conf.set(IndexOutputConfigurator.enumToConfKey(implementingClass, (Enum)WriteOpts.INDEX_TABLE_NAME), tableName);
        }
    }

    public static String getIndexTableName(Class<?> implementingClass, Configuration conf) {
        return conf.get(IndexOutputConfigurator.enumToConfKey(implementingClass, (Enum)WriteOpts.INDEX_TABLE_NAME));
    }

    public static void setIndexColumns(Class<?> implementingClass, Configuration conf, String tableName) {
        if (tableName != null) {
            conf.set(IndexOutputConfigurator.enumToConfKey(implementingClass, (Enum)WriteOpts.INDEX_COLUMNS), tableName);
        }
    }

    public static String getIndexColumns(Class<?> implementingClass, Configuration conf) {
        return conf.get(IndexOutputConfigurator.enumToConfKey(implementingClass, (Enum)WriteOpts.INDEX_COLUMNS));
    }

    public static void setRecordEncoding(Class<?> implementingClass, Configuration conf, Boolean isBinary) {
        conf.set(IndexOutputConfigurator.enumToConfKey(implementingClass, (Enum)WriteOpts.BINARY_ENCODING), isBinary.toString());
    }

    public static Boolean getRecordEncoding(Class<?> implementingClass, Configuration conf) {
        return Boolean.valueOf(conf.get(IndexOutputConfigurator.enumToConfKey(implementingClass, (Enum)WriteOpts.BINARY_ENCODING)));
    }

    public static enum WriteOpts {
        DEFAULT_TABLE_NAME,
        INDEX_TABLE_NAME,
        INDEX_COLUMNS,
        COLUMN_TYPES,
        BINARY_ENCODING,
        BATCH_WRITER_CONFIG;

    }
}

