/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo.mr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.MultiTableBatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.mapred.AccumuloOutputFormat;
import org.apache.accumulo.core.data.ColumnUpdate;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.accumulo.AccumuloIndexLexicoder;
import org.apache.hadoop.hive.accumulo.mr.AccumuloIndexDefinition;
import org.apache.hadoop.hive.accumulo.mr.IndexOutputConfigurator;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccumuloIndexedOutputFormat
extends AccumuloOutputFormat {
    private static final Logger LOG = LoggerFactory.getLogger(AccumuloIndexedOutputFormat.class);
    private static final Class<?> CLASS = AccumuloOutputFormat.class;
    private static final byte[] EMPTY_BYTES = new byte[0];

    public static void setIndexTableName(JobConf job, String tableName) {
        IndexOutputConfigurator.setIndexTableName(CLASS, (Configuration)job, tableName);
    }

    protected static String getIndexTableName(JobConf job) {
        return IndexOutputConfigurator.getIndexTableName(CLASS, (Configuration)job);
    }

    public static void setIndexColumns(JobConf job, String fields) {
        IndexOutputConfigurator.setIndexColumns(CLASS, (Configuration)job, fields);
    }

    protected static String getIndexColumns(JobConf job) {
        return IndexOutputConfigurator.getIndexColumns(CLASS, (Configuration)job);
    }

    public static void setStringEncoding(JobConf job, Boolean isStringEncoding) {
        IndexOutputConfigurator.setRecordEncoding(CLASS, (Configuration)job, isStringEncoding);
    }

    protected static Boolean getStringEncoding(JobConf job) {
        return IndexOutputConfigurator.getRecordEncoding(CLASS, (Configuration)job);
    }

    public RecordWriter<Text, Mutation> getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
        try {
            return new AccumuloRecordWriter(job);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected static class AccumuloRecordWriter
    implements RecordWriter<Text, Mutation> {
        private MultiTableBatchWriter mtbw = null;
        private Map<Text, BatchWriter> bws = null;
        private Text defaultTableName = null;
        private Text indexTableName = null;
        private boolean simulate = false;
        private boolean createTables = false;
        private boolean isStringEncoded = true;
        private long mutCount = 0L;
        private long valCount = 0L;
        private Connector conn;
        private AccumuloIndexDefinition indexDef = null;

        protected AccumuloRecordWriter(JobConf job) throws AccumuloException, AccumuloSecurityException, IOException {
            this.isStringEncoded = AccumuloIndexedOutputFormat.getStringEncoding(job);
            this.simulate = AccumuloIndexedOutputFormat.getSimulationMode((JobConf)job);
            this.createTables = AccumuloIndexedOutputFormat.canCreateTables((JobConf)job);
            if (this.simulate) {
                LOG.info("Simulating output only. No writes to tables will occur");
            }
            this.bws = new HashMap<Text, BatchWriter>();
            String tname = AccumuloIndexedOutputFormat.getDefaultTableName((JobConf)job);
            this.defaultTableName = tname == null ? null : new Text(tname);
            String iname = AccumuloIndexedOutputFormat.getIndexTableName(job);
            if (iname != null) {
                LOG.info("Index Table = {}", (Object)iname);
                this.indexTableName = new Text(iname);
                this.indexDef = this.createIndexDefinition(job, tname, iname);
            }
            if (!this.simulate) {
                this.conn = AccumuloIndexedOutputFormat.getInstance((JobConf)job).getConnector(AccumuloIndexedOutputFormat.getPrincipal((JobConf)job), AccumuloIndexedOutputFormat.getAuthenticationToken((JobConf)job));
                this.mtbw = this.conn.createMultiTableBatchWriter(AccumuloIndexedOutputFormat.getBatchWriterOptions((JobConf)job));
            }
        }

        AccumuloIndexDefinition createIndexDefinition(JobConf job, String tname, String iname) {
            AccumuloIndexDefinition def = new AccumuloIndexDefinition(tname, iname);
            String cols = AccumuloIndexedOutputFormat.getIndexColumns(job);
            LOG.info("Index Cols = {}", (Object)cols);
            def.setColumnTuples(cols);
            return def;
        }

        public void write(Text table, Mutation mutation) throws IOException {
            if (table == null || table.toString().isEmpty()) {
                table = this.defaultTableName;
            }
            if (!this.simulate && table == null) {
                throw new IOException("No table or default table specified. Try simulation mode next time");
            }
            ++this.mutCount;
            this.valCount += (long)mutation.size();
            this.printMutation(table, mutation);
            if (!this.simulate) {
                List<Mutation> idxMuts;
                if (!this.bws.containsKey(table)) {
                    try {
                        this.addTable(table);
                    }
                    catch (Exception var5) {
                        LOG.error("Could not add table", (Throwable)var5);
                        throw new IOException(var5);
                    }
                }
                if (this.indexTableName != null && !this.bws.containsKey(this.indexTableName)) {
                    try {
                        this.addTable(this.indexTableName);
                    }
                    catch (Exception var6) {
                        LOG.error("Could not add index table", (Throwable)var6);
                        throw new IOException(var6);
                    }
                }
                try {
                    this.bws.get(table).addMutation(mutation);
                }
                catch (MutationsRejectedException var4) {
                    throw new IOException(var4);
                }
                if (this.indexTableName != null && !(idxMuts = this.getIndexMutations(mutation)).isEmpty()) {
                    try {
                        BatchWriter writer = this.bws.get(this.indexTableName);
                        for (Mutation m : idxMuts) {
                            writer.addMutation(m);
                        }
                    }
                    catch (MutationsRejectedException var4) {
                        throw new IOException(var4);
                    }
                }
            }
        }

        public void addTable(Text tableName) throws AccumuloException, AccumuloSecurityException {
            if (this.simulate) {
                LOG.info("Simulating adding table: {}", (Object)tableName);
            } else {
                LOG.debug("Adding table: {}", (Object)tableName);
                BatchWriter bw = null;
                String table = tableName.toString();
                if (this.createTables && !this.conn.tableOperations().exists(table)) {
                    try {
                        this.conn.tableOperations().create(table);
                    }
                    catch (AccumuloSecurityException var8) {
                        LOG.error("Accumulo security violation creating {}", (Object)table, (Object)var8);
                        throw var8;
                    }
                    catch (TableExistsException var9) {
                        LOG.warn("Table Exists {}", (Object)table, (Object)var9);
                    }
                }
                try {
                    bw = this.mtbw.getBatchWriter(table);
                }
                catch (TableNotFoundException var5) {
                    LOG.error("Accumulo table {} doesn't exist and cannot be created.", (Object)table, (Object)var5);
                    throw new AccumuloException((Throwable)var5);
                }
                if (bw != null) {
                    this.bws.put(tableName, bw);
                }
            }
        }

        private int printMutation(Text table, Mutation m) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Table {} row key: {}", (Object)table, (Object)this.hexDump(m.getRow()));
                for (ColumnUpdate cu : m.getUpdates()) {
                    LOG.trace("Table {} column: {}:{}", new Object[]{table, this.hexDump(cu.getColumnFamily()), this.hexDump(cu.getColumnQualifier())});
                    LOG.trace("Table {} security: {}", (Object)table, (Object)new ColumnVisibility(cu.getColumnVisibility()).toString());
                    LOG.trace("Table {} value: {}", (Object)table, (Object)this.hexDump(cu.getValue()));
                }
            }
            return m.getUpdates().size();
        }

        private List<Mutation> getIndexMutations(Mutation baseMut) {
            ArrayList<Mutation> indexMuts = new ArrayList<Mutation>();
            if (null != this.indexDef) {
                byte[] rowId = baseMut.getRow();
                for (ColumnUpdate cu : baseMut.getUpdates()) {
                    String cq;
                    String cf = new String(cu.getColumnFamily());
                    String colType = this.indexDef.getColType(cf, cq = new String(cu.getColumnQualifier()));
                    if (colType == null) continue;
                    LOG.trace("Building index for column {}:{}", (Object)cf, (Object)cq);
                    Mutation m = new Mutation(AccumuloIndexLexicoder.encodeValue(cu.getValue(), colType, this.isStringEncoded));
                    String colFam = cf + "_" + cq;
                    m.put(colFam.getBytes(), rowId, new ColumnVisibility(cu.getColumnVisibility()), EMPTY_BYTES);
                    indexMuts.add(m);
                }
            }
            return indexMuts;
        }

        private String hexDump(byte[] ba) {
            StringBuilder sb = new StringBuilder();
            byte[] arr = ba;
            int len = ba.length;
            for (int i = 0; i < len; ++i) {
                byte b = arr[i];
                if (b > 32 && b < 126) {
                    sb.append((char)b);
                    continue;
                }
                sb.append(String.format("x%02x", b));
            }
            return sb.toString();
        }

        public void close(Reporter reporter) throws IOException {
            LOG.debug("mutations written: {}, values written: {}", (Object)this.mutCount, (Object)this.valCount);
            if (!this.simulate) {
                try {
                    this.mtbw.close();
                }
                catch (MutationsRejectedException var7) {
                    if (var7.getAuthorizationFailuresMap().size() > 0) {
                        HashMap tables = new HashMap();
                        for (Map.Entry ke : var7.getAuthorizationFailuresMap().entrySet()) {
                            HashSet secCodes = (HashSet)tables.get(((KeyExtent)ke.getKey()).getTableId().toString());
                            if (secCodes == null) {
                                secCodes = new HashSet();
                                tables.put(((KeyExtent)ke.getKey()).getTableId().toString(), secCodes);
                            }
                            secCodes.addAll((Collection)ke.getValue());
                        }
                        LOG.error("Not authorized to write to tables {}", tables);
                    }
                    if (var7.getConstraintViolationSummaries().size() > 0) {
                        LOG.error("Constraint violations : {}", (Object)var7.getConstraintViolationSummaries().size());
                    }
                    throw new IOException(var7);
                }
            }
        }
    }
}

