/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.mock.MockInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.hadoop.conf.Configuration;

public class AccumuloConnectionParameters {
    public static final String USER_NAME = "accumulo.user.name";
    public static final String USER_PASS = "accumulo.user.pass";
    public static final String ZOOKEEPERS = "accumulo.zookeepers";
    public static final String INSTANCE_NAME = "accumulo.instance.name";
    public static final String TABLE_NAME = "accumulo.table.name";
    public static final String SASL_ENABLED = "accumulo.sasl.enabled";
    public static final String USER_KEYTAB = "accumulo.user.keytab";
    public static final String USE_MOCK_INSTANCE = "accumulo.mock.instance";
    protected Configuration conf;
    protected boolean useMockInstance = false;

    public AccumuloConnectionParameters(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public String getAccumuloUserName() {
        Preconditions.checkNotNull((Object)this.conf);
        return this.conf.get(USER_NAME);
    }

    public String getAccumuloPassword() {
        Preconditions.checkNotNull((Object)this.conf);
        return this.conf.get(USER_PASS);
    }

    public String getAccumuloInstanceName() {
        Preconditions.checkNotNull((Object)this.conf);
        return this.conf.get(INSTANCE_NAME);
    }

    public String getZooKeepers() {
        Preconditions.checkNotNull((Object)this.conf);
        return this.conf.get(ZOOKEEPERS);
    }

    public String getAccumuloTableName() {
        Preconditions.checkNotNull((Object)this.conf);
        return this.conf.get(TABLE_NAME);
    }

    public boolean useMockInstance() {
        Preconditions.checkNotNull((Object)this.conf);
        return this.conf.getBoolean(USE_MOCK_INSTANCE, false);
    }

    public boolean useSasl() {
        Preconditions.checkNotNull((Object)this.conf);
        return this.conf.getBoolean(SASL_ENABLED, false);
    }

    public String getAccumuloKeytab() {
        Preconditions.checkNotNull((Object)this.conf);
        return this.conf.get(USER_KEYTAB);
    }

    public Instance getInstance() {
        String instanceName = this.getAccumuloInstanceName();
        if (null == instanceName) {
            throw new IllegalArgumentException("Accumulo instance name must be provided in hiveconf using accumulo.instance.name");
        }
        if (this.useMockInstance()) {
            return new MockInstance(instanceName);
        }
        String zookeepers = this.getZooKeepers();
        if (null == zookeepers) {
            throw new IllegalArgumentException("ZooKeeper quorum string must be provided in hiveconf using accumulo.zookeepers");
        }
        ClientConfiguration clientConf = ClientConfiguration.loadDefault().withInstance(instanceName).withZkHosts(zookeepers).withSasl(this.useSasl());
        return new ZooKeeperInstance(clientConf);
    }

    public Connector getConnector() throws AccumuloException, AccumuloSecurityException {
        Instance inst = this.getInstance();
        return this.getConnector(inst);
    }

    public Connector getConnector(Instance inst) throws AccumuloException, AccumuloSecurityException {
        String username = this.getAccumuloUserName();
        if (null == username) {
            throw new IllegalArgumentException("Accumulo user name must be provided in hiveconf using accumulo.user.name");
        }
        if (this.useSasl()) {
            return inst.getConnector(username, (AuthenticationToken)this.getKerberosToken(username));
        }
        String password = this.getAccumuloPassword();
        if (null == password) {
            throw new IllegalArgumentException("Accumulo password must be provided in hiveconf using accumulo.user.pass");
        }
        return inst.getConnector(username, (AuthenticationToken)new PasswordToken((CharSequence)password));
    }

    public AuthenticationToken getKerberosToken() {
        if (!this.useSasl()) {
            throw new IllegalArgumentException("Cannot construct KerberosToken when SASL is disabled");
        }
        String keytab = this.getAccumuloKeytab();
        String username = this.getAccumuloUserName();
        if (null != keytab) {
            return this.getKerberosToken(username, keytab);
        }
        return this.getKerberosToken(username);
    }

    KerberosToken getKerberosToken(String username) {
        try {
            return new KerberosToken(username);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to instantiate KerberosToken.", e);
        }
    }

    KerberosToken getKerberosToken(String username, String keytab) {
        try {
            return new KerberosToken(username, new File(keytab), true);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to instantiate KerberosToken.", e);
        }
    }
}

