/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.Tag;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor"})
public interface RawCell
extends Cell {
    public static final int MAX_TAGS_LENGTH = 65535;

    default public byte[] cloneTags() {
        return PrivateCellUtil.cloneTags(this);
    }

    default public Iterator<Tag> getTags() {
        return PrivateCellUtil.tagsIterator(this);
    }

    default public Optional<Tag> getTag(byte type) {
        return PrivateCellUtil.getTag(this, type);
    }

    public static void checkForTagsLength(int tagsLength) {
        if (tagsLength > 65535) {
            throw new IllegalArgumentException("tagslength " + tagsLength + " > " + 65535);
        }
    }

    public static Cell createCell(Cell cell, List<Tag> tags) {
        return PrivateCellUtil.createCell(cell, tags);
    }
}

